/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsq;
import com.google.android.gms.internal.zzsw;
import com.google.android.gms.internal.zzte;
import com.google.android.gms.internal.zztf;
import com.google.android.gms.internal.zzth;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzaaF = new ArrayList<Runnable>();
    private boolean zztW;
    private Set<zza> zzaaG = new HashSet<zza>();
    private boolean zzaaH;
    private boolean zzaaI;
    private volatile boolean zzaaJ;
    private boolean zzaaK;

    public void initialize() {
        this.zzlV();
        this.zztW = true;
    }

    void zzlV() {
        zzth zzth2 = this.zzma();
        zzth2.zzpi();
        if (zzth2.zzpm()) {
            this.setDryRun(zzth2.zzpn());
        }
        zzth2.zzpi();
    }

    public boolean isInitialized() {
        return this.zztW;
    }

    public GoogleAnalytics(zzrw zzrw2) {
        super(zzrw2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzrw.zzW(context).zznE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzlW() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzaaF != null) {
                for (Runnable runnable : zzaaF) {
                    runnable.run();
                }
                zzaaF = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean bl) {
        this.zzaaI = bl;
    }

    public boolean isDryRunEnabled() {
        return this.zzaaI;
    }

    @TargetApi(value=14)
    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzaaH) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzaaH = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzaaH) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzaaG) {
            zza2.zzo(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzaaH) {
            this.zzn(activity);
        }
    }

    void zzn(Activity activity) {
        for (zza zza2 : this.zzaaG) {
            zza2.zzp(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzlM(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzte zzte2;
            zztf zztf2;
            Tracker tracker = new Tracker(this.zzlM(), null, null);
            if (n > 0 && (zztf2 = (zztf)(zzte2 = new zzte(this.zzlM())).zzaG(n)) != null) {
                tracker.zza(zztf2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzaaG.add(zza2);
        Context context = this.zzlM().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzaaG.remove(zza2);
    }

    public void setAppOptOut(boolean bl) {
        this.zzaaJ = bl;
        if (this.zzaaJ) {
            this.zzlZ().zznj();
        }
    }

    public boolean getAppOptOut() {
        return this.zzaaJ;
    }

    @Deprecated
    public Logger getLogger() {
        return zzsw.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzsw.setLogger(logger);
        if (!this.zzaaK) {
            String string = zzsq.zzaek.get();
            Log.i((String)zzsq.zzaek.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzaaK = true;
        }
    }

    public String zzlX() {
        zzac.zzdo((String)"getClientId can not be called from the main thread");
        return this.zzlM().zznH().zzop();
    }

    public void setLocalDispatchPeriod(int n) {
        this.zzlZ().setLocalDispatchPeriod(n);
    }

    public void dispatchLocalHits() {
        this.zzlZ().zznk();
    }

    void zzlY() {
        this.zzlZ().zznl();
    }

    private zzrs zzlZ() {
        return this.zzlM().zzlZ();
    }

    private zzth zzma() {
        return this.zzlM().zzma();
    }

    @TargetApi(value=14)
    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzn(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzo(Activity var1);

        public void zzp(Activity var1);
    }
}

