/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrv;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsv;
import com.google.android.gms.internal.zztf;
import com.google.android.gms.internal.zztg;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzru {
    private boolean zzabr;
    private final Map<String, String> zzFs = new HashMap<String, String>();
    private final Map<String, String> zzabs = new HashMap<String, String>();
    private final zzsv zzabt;
    private final zza zzabu;
    private ExceptionReporter zzabv;
    private zztf zzabw;

    Tracker(zzrw zzrw2, String string, zzsv zzsv2) {
        super(zzrw2);
        if (string != null) {
            this.zzFs.put("&tid", string);
        }
        this.zzFs.put("useSecure", "1");
        this.zzFs.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzabt = zzsv2 == null ? new zzsv("tracking", this.zznq()) : zzsv2;
        this.zzabu = new zza(zzrw2);
    }

    @Override
    protected void zzmr() {
        String string;
        this.zzabu.initialize();
        String string2 = this.zzma().zzmx();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzma().zzmy()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zztf zztf2) {
        String string;
        this.zzbO("Loading Tracker config values");
        this.zzabw = zztf2;
        if (this.zzabw.zzpS()) {
            string = this.zzabw.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzabw.zzpT()) {
            string = Double.toString(this.zzabw.zzpU());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzabw.zzpV()) {
            int n = this.zzabw.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzabw.zzpW()) {
            boolean bl = this.zzabw.zzpX();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzabw.zzpY()) {
            boolean bl = this.zzabw.zzpZ();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzabw.zzqa());
    }

    private boolean zzms() {
        return this.zzabv != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzms() == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzabv = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzabv);
                this.zzbO("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzabv.zzlU();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzbO("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long l) {
        this.zzabu.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzabu.enableAutoActivityTracking(bl);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzac.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzac.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        final long l = this.zznq().currentTimeMillis();
        if (this.zzlT().getAppOptOut()) {
            this.zzbP("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzlT().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzFs, hashMap);
        Tracker.zzb(map, hashMap);
        final boolean bl2 = zztg.zzg(this.zzFs.get("useSecure"), true);
        Tracker.zzc(this.zzabs, hashMap);
        this.zzabs.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zznr().zzg(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zznr().zzg(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzmt();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzFs.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzFs.put("&a", Integer.toString(n));
            }
        }
        this.zznt().zzg(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzabu.zzmu()) {
                    hashMap.put("sc", "start");
                }
                zztg.zzd(hashMap, "cid", Tracker.this.zzlT().zzlX());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zztg.zza(d = zztg.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                zzrr zzrr2 = Tracker.this.zznx();
                if (bl3) {
                    zztg.zzb(hashMap, "ate", zzrr2.zzmV());
                    zztg.zzc(hashMap, "adid", zzrr2.zznf());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzre zzre2 = Tracker.this.zzny().zznX();
                zztg.zzc(hashMap, "an", zzre2.zzmx());
                zztg.zzc(hashMap, "av", zzre2.zzmy());
                zztg.zzc(hashMap, "aid", zzre2.zzjI());
                zztg.zzc(hashMap, "aiid", zzre2.zzmz());
                hashMap.put("v", "1");
                hashMap.put("_v", zzrv.zzacP);
                zztg.zzc(hashMap, "ul", Tracker.this.zznz().zzpb().getLanguage());
                zztg.zzc(hashMap, "sr", Tracker.this.zznz().zzpc());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzabt.zzpv()) {
                    Tracker.this.zznr().zzg(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zztg.zzce((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzst zzst2 = new zzst(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zznr().zzc("Dry run enabled. Would have sent hit", zzst2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zztg.zza(hashMap2, "uid", hashMap);
                zztg.zza(hashMap2, "an", hashMap);
                zztg.zza(hashMap2, "aid", hashMap);
                zztg.zza(hashMap2, "av", hashMap);
                zztg.zza(hashMap2, "aiid", hashMap);
                zzry zzry2 = new zzry(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzlZ().zza(zzry2);
                hashMap.put("_s", String.valueOf(l2));
                zzst zzst3 = new zzst(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzlZ().zza(zzst3);
            }
        });
    }

    public String get(String string) {
        this.zznA();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzFs.containsKey(string)) {
            return this.zzFs.get(string);
        }
        if (string.equals("&ul")) {
            return zztg.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zznw().zzop();
        }
        if (string.equals("&sr")) {
            return this.zznz().zzpc();
        }
        if (string.equals("&aid")) {
            return this.zzny().zznX().zzjI();
        }
        if (string.equals("&an")) {
            return this.zzny().zznX().zzmx();
        }
        if (string.equals("&av")) {
            return this.zzny().zznX().zzmy();
        }
        if (string.equals("&aiid")) {
            return this.zzny().zznX().zzmz();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzac.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzFs.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zztg.zzW(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzbR("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zztg.zzW(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzabs.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzabs.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzabs.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzabs.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzabs.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzabs.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzabs.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzabs.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzabs.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzabs.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzabr = bl;
    }

    boolean zzmt() {
        return this.zzabr;
    }

    static String zzq(Activity activity) {
        zzac.zzw((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzru
    implements GoogleAnalytics.zza {
        private boolean zzabF;
        private int zzabG;
        private long zzabH;
        private boolean zzabI;
        private long zzabJ;

        protected zza(zzrw zzrw2) {
            super(zzrw2);
            this.zzabH = -1L;
        }

        @Override
        protected void zzmr() {
        }

        public void setSessionTimeout(long l) {
            this.zzabH = l;
            this.zzmv();
        }

        public void enableAutoActivityTracking(boolean bl) {
            this.zzabF = bl;
            this.zzmv();
        }

        public synchronized boolean zzmu() {
            boolean bl = this.zzabI;
            this.zzabI = false;
            return bl;
        }

        private void zzmv() {
            if (this.zzabH >= 0L || this.zzabF) {
                this.zzlT().zza(Tracker.this.zzabu);
            } else {
                this.zzlT().zzb(Tracker.this.zzabu);
            }
        }

        @Override
        public void zzo(Activity activity) {
            if (this.zzabG == 0 && this.zzmw()) {
                this.zzabI = true;
            }
            ++this.zzabG;
            if (this.zzabF) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzabw != null ? Tracker.this.zzabw.zzr(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzq(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzp(Activity activity) {
            --this.zzabG;
            this.zzabG = Math.max(0, this.zzabG);
            if (this.zzabG == 0) {
                this.zzabJ = this.zznq().elapsedRealtime();
            }
        }

        boolean zzmw() {
            return this.zznq().elapsedRealtime() >= this.zzabJ + Math.max(1000L, this.zzabH);
        }
    }
}

