/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zztg;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zzrr
extends zzru {
    public static boolean zzacz;
    private AdvertisingIdClient.Info zzacA;
    private final zztd zzacB;
    private String zzacC;
    private boolean zzacD = false;
    private Object zzacE = new Object();

    zzrr(zzrw zzrw2) {
        super(zzrw2);
        this.zzacB = new zztd(zzrw2.zznq());
    }

    @Override
    protected void zzmr() {
    }

    public boolean zzmV() {
        this.zznA();
        AdvertisingIdClient.Info info = this.zzng();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zznf() {
        this.zznA();
        AdvertisingIdClient.Info info = this.zzng();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zzng() {
        if (this.zzacB.zzz(1000L)) {
            this.zzacB.start();
            AdvertisingIdClient.Info info = this.zznh();
            if (this.zza(this.zzacA, info)) {
                this.zzacA = info;
            } else {
                this.zzbS("Failed to reset client id on adid change. Not using adid");
                this.zzacA = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzacA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zznw().zzop();
        Object object = this.zzacE;
        synchronized (object) {
            String string4;
            if (!this.zzacD) {
                this.zzacC = this.zzni();
                this.zzacD = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzacC)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    String string6 = String.valueOf(string);
                    String string7 = String.valueOf(string3);
                    return this.zzbN(string7.length() != 0 ? string6.concat(string7) : new String(string6));
                }
                String string8 = String.valueOf(string4);
                String string9 = String.valueOf(string3);
                this.zzacC = zzrr.zzbM(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string3);
            string4 = zzrr.zzbM(string11.length() != 0 ? string10.concat(string11) : new String(string10));
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzacC)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzacC)) {
                this.zzbO("Resetting the client id because Advertising Id changed.");
                string3 = this.zznw().zzoq();
                this.zza("New client Id", string3);
            }
            String string12 = String.valueOf(string);
            String string13 = String.valueOf(string3);
            return this.zzbN(string13.length() != 0 ? string12.concat(string13) : new String(string12));
        }
    }

    protected AdvertisingIdClient.Info zznh() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbR("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzacz) break block3;
                zzacz = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzbM(String string) {
        MessageDigest messageDigest = zztg.zzcg("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzbN(String string) {
        try {
            String string2 = zzrr.zzbM(string);
            this.zzbO("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzacC = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzni() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbR("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzbO("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

