/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zztg;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzsa
extends zzru
implements Closeable {
    private static final String zzadt = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzadu = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza zzadv;
    private final zztd zzadw = new zztd(this.zznq());
    private final zztd zzadx = new zztd(this.zznq());

    zzsa(zzrw zzrw2) {
        super(zzrw2);
        String string = this.zznV();
        this.zzadv = new zza(zzrw2.getContext(), string);
    }

    @Override
    protected void zzmr() {
    }

    public void beginTransaction() {
        this.zznA();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zznA();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zznA();
        this.getWritableDatabase().endTransaction();
    }

    public void zznQ() {
        this.zzmq();
        this.zznA();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zznR() {
        this.zzmq();
        this.zznA();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzst zzst2) {
        zzac.zzw((Object)zzst2);
        this.zzmq();
        this.zznA();
        String string = zzsa.zze(zzst2);
        if (string.length() > 8192) {
            this.zznr().zza(zzst2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zznU();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string);
        contentValues.put("hit_time", Long.valueOf(zzst2.zzpq()));
        contentValues.put("hit_app_id", Integer.valueOf(zzst2.zzpo()));
        contentValues.put("hit_url", this.zzd(zzst2));
        try {
            long l = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l == -1L) {
                this.zzbS("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l, zzst2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zznL() {
        this.zzmq();
        this.zznA();
        long l = this.zzb("SELECT COUNT(*) FROM hits2", null);
        return l;
    }

    boolean isEmpty() {
        return this.zznL() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzs(long l) {
        this.zzmq();
        this.zznA();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzst> zzt(long l) {
        zzac.zzas((l >= 0L ? 1 : 0) != 0);
        this.zzmq();
        this.zznA();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzst> arrayList = new ArrayList<zzst>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzbT(string);
                    boolean bl = zztg.zzci(string2);
                    arrayList.add(new zzst(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzst> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzr(List<Long> list) {
        Long l;
        zzac.zzw(list);
        this.zzmq();
        this.zznA();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzu(long l) {
        this.zzmq();
        this.zznA();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zzr(arrayList);
    }

    public int zznS() {
        this.zzmq();
        this.zznA();
        if (!this.zzadw.zzz(86400000L)) {
            return 0;
        }
        this.zzadw.start();
        this.zzbO("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zznq().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zznT() {
        this.zzmq();
        this.zznA();
        return this.zza(zzadu, null, 0L);
    }

    public void zza(long l, String string) {
        zzac.zzdv((String)string);
        this.zznA();
        this.zzmq();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l), string});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzry zzry2) {
        zzac.zzw((Object)zzry2);
        this.zznA();
        this.zzmq();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string = zzsa.zzS(zzry2.zzfz());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzry2.zznI()));
        contentValues.put("cid", zzry2.zzlX());
        contentValues.put("tid", zzry2.zznJ());
        contentValues.put("adid", Integer.valueOf(zzry2.zznK() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzry2.zznL()));
        contentValues.put("params", string);
        try {
            long l = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzbS("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l, String string, String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zznA();
        this.zzmq();
        long l2 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
        return l2;
    }

    public List<zzry> zzv(long l) {
        this.zznA();
        this.zzmq();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zzns().zzoU();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l)};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzry> arrayList = new ArrayList<zzry>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzbU(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzry zzry2 = new zzry(l, (String)object, string3, bl, l2, map);
                    arrayList.add(zzry2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzbR("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.zzadv.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzst zzst2) {
        if (zzst2.zzps()) {
            return this.zzns().zzoJ();
        }
        return this.zzns().zzoK();
    }

    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return l;
        }
    }

    private void zznU() {
        int n = this.zzns().zzoT();
        long l = this.zznL();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = this.zzs(l2);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zzr(list);
        }
    }

    private static String zze(zzst zzst2) {
        zzac.zzw((Object)zzst2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzst2.zzfz().entrySet()) {
            String string = object2.getKey();
            if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string)) continue;
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String zzS(Map<String, String> map) {
        zzac.zzw(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey();
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    Map<String, String> zzbT(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return zzn.zza((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzbU(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return zzn.zza((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzadv.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zznV() {
        return this.zzns().zzoV();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzsa.this.zzadx.zzz(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzsa.this.zzadx.start();
                zzsa.this.zzbS("Opening the database failed, dropping the table and recreating it");
                String string = zzsa.this.zznV();
                zzsa.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzsa.this.zzadx.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzsa.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            String[] stringArray2 = stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"};
            for (int i = 0; i < 4; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database hits2 is missing required column: ".concat(string2) : new String("Database hits2 is missing required column: "));
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            String[] stringArray2 = stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"};
            for (int i = 0; i < 6; ++i) {
                String string = stringArray2[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database properties is missing required column: ".concat(string2) : new String("Database properties is missing required column: "));
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(sQLiteDatabase, "hits2")) {
                sQLiteDatabase.execSQL(zzadt);
            } else {
                this.zza(sQLiteDatabase);
            }
            if (!this.zza(sQLiteDatabase, "properties")) {
                sQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(sQLiteDatabase);
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzsp.zzbZ(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

