/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzrw;

abstract class zzsl {
    private final zzrw zzacN;
    private static volatile Handler zzaec;
    private final Runnable zzv;
    private volatile long zzaed;

    zzsl(zzrw zzrw2) {
        zzac.zzw((Object)zzrw2);
        this.zzacN = zzrw2;
        this.zzv = new Runnable(){

            @Override
            public void run() {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    zzsl.this.zzacN.zznt().zzg(this);
                } else {
                    boolean bl = zzsl.this.zzcv();
                    zzsl.this.zzaed = 0L;
                    if (bl) {
                        zzsl.this.run();
                    }
                }
            }
        };
    }

    public abstract void run();

    public void zzx(long l) {
        this.cancel();
        if (l >= 0L) {
            this.zzaed = this.zzacN.zznq().currentTimeMillis();
            boolean bl = this.getHandler().postDelayed(this.zzv, l);
            if (!bl) {
                this.zzacN.zznr().zze("Failed to schedule delayed post. time", l);
            }
        }
    }

    public void zzy(long l) {
        if (!this.zzcv()) {
            return;
        }
        if (l < 0L) {
            this.cancel();
            return;
        }
        long l2 = Math.abs(this.zzacN.zznq().currentTimeMillis() - this.zzaed);
        long l3 = l - l2;
        if (l3 < 0L) {
            l3 = 0L;
        }
        this.getHandler().removeCallbacks(this.zzv);
        boolean bl = this.getHandler().postDelayed(this.zzv, l3);
        if (!bl) {
            this.zzacN.zznr().zze("Failed to adjust delayed post. time", l3);
        }
    }

    public long zzpa() {
        if (this.zzaed == 0L) {
            return 0L;
        }
        return Math.abs(this.zzacN.zznq().currentTimeMillis() - this.zzaed);
    }

    public boolean zzcv() {
        return this.zzaed != 0L;
    }

    public void cancel() {
        this.zzaed = 0L;
        this.getHandler().removeCallbacks(this.zzv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        if (zzaec != null) {
            return zzaec;
        }
        Class<zzsl> clazz = zzsl.class;
        synchronized (zzsl.class) {
            if (zzaec == null) {
                zzaec = new Handler(this.zzacN.getContext().getMainLooper());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaec;
        }
    }
}

