/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsx;

class zzsy
extends BroadcastReceiver {
    static final String zzafu = zzsy.class.getName();
    private final zzrw zzacN;
    private boolean zzafv;
    private boolean zzafw;

    zzsy(zzrw zzrw2) {
        zzac.zzw((Object)zzrw2);
        this.zzacN = zzrw2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzpy();
        String string = intent.getAction();
        this.zzacN.zznr().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzpA();
            if (this.zzafw != bl) {
                this.zzafw = bl;
                this.zzlZ().zzV(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzafu)) {
                this.zzlZ().zznn();
            }
            return;
        }
        this.zzacN.zznr().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzpx() {
        this.zzpy();
        if (this.zzafv) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzafw = this.zzpA();
        this.zzacN.zznr().zza("Registering connectivity change receiver. Network connected", this.zzafw);
        this.zzafv = true;
    }

    private void zzpy() {
        this.zznr();
        this.zzlZ();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzacN.zznr().zzbO("Unregistering connectivity change receiver");
        this.zzafv = false;
        this.zzafw = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zznr().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzpz() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzafu, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzafv;
    }

    public boolean isConnected() {
        if (!this.zzafv) {
            this.zzacN.zznr().zzbR("Connectivity unknown. Receiver not registered");
        }
        return this.zzafw;
    }

    protected boolean zzpA() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzacN.getContext();
    }

    private zzsx zznr() {
        return this.zzacN.zznr();
    }

    private zzrs zzlZ() {
        return this.zzacN.zzlZ();
    }
}

