/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrv;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzsg;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zztg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

class zzsz
extends zzru {
    private final String zzHY = zzsz.zza("GoogleAnalytics", zzrv.VERSION, Build.VERSION.RELEASE, zztg.zza(Locale.getDefault()), Build.MODEL, Build.ID);
    private final zztd zzafx;
    private static final byte[] zzafy = "\n".getBytes();

    zzsz(zzrw zzrw2) {
        super(zzrw2);
        this.zzafx = new zztd(zzrw2.zznq());
    }

    @Override
    protected void zzmr() {
        this.zza("Network initialized. User agent", this.zzHY);
    }

    private static String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    public boolean zzpA() {
        this.zzmq();
        this.zznA();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzbO("No network connectivity");
            return false;
        }
        return true;
    }

    public List<Long> zzt(List<zzst> list) {
        boolean bl;
        boolean bl2;
        this.zzmq();
        this.zznA();
        zzac.zzw(list);
        if (this.zzns().zzoP().isEmpty() || !this.zzafx.zzz(this.zzns().zzoI() * 1000L)) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = this.zzns().zzoN() != zzsd.zzadK;
            boolean bl3 = bl = this.zzns().zzoO() == zzsg.zzadV;
        }
        if (bl2) {
            return this.zza(list, bl);
        }
        return this.zzu(list);
    }

    List<Long> zzu(List<zzst> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (zzst zzst2 : list) {
            if (!this.zzg(zzst2)) break;
            arrayList.add(zzst2.zzpp());
            if (arrayList.size() < this.zzns().zzoG()) continue;
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL) {
        zzac.zzw((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.connect();
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzlZ().zzno();
            }
            this.zzb("GET status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL, byte[] byArray) {
        zzac.zzw((Object)uRL);
        zzac.zzw((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (this.zzkh()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzlZ().zzno();
            }
            this.zzb("POST status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static byte[] zzk(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL, byte[] byArray) {
        zzac.zzw((Object)uRL);
        zzac.zzw((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            byte[] byArray2 = zzsz.zzk(byArray);
            this.zza("POST compressed size, ratio %, url", byArray2.length, 100L * (long)byArray2.length / (long)byArray.length, uRL);
            if (byArray2.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray2.length, byArray.length);
            }
            if (this.zzkh()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", string.length() != 0 ? "\n".concat(string) : new String("\n"));
            }
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzlZ().zzno();
            }
            this.zzb("POST status", n);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http connection input stream", iOException);
                }
            }
        }
    }

    HttpURLConnection zzc(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(this.zzns().zzoW());
        httpURLConnection.setReadTimeout(this.zzns().zzoX());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzHY);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private boolean zzg(zzst zzst2) {
        zzac.zzw((Object)zzst2);
        String string = this.zza(zzst2, !zzst2.zzps());
        if (string == null) {
            this.zznr().zza(zzst2, "Error formatting hit for upload");
            return true;
        }
        if (string.length() <= this.zzns().zzoy()) {
            URL uRL = this.zzb(zzst2, string);
            if (uRL == null) {
                this.zzbS("Failed to build collect GET endpoint url");
                return false;
            }
            return this.zzb(uRL) == 200;
        }
        string = this.zza(zzst2, false);
        if (string == null) {
            this.zznr().zza(zzst2, "Error formatting hit for POST upload");
            return true;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > this.zzns().zzoA()) {
            this.zznr().zza(zzst2, "Hit payload exceeds size limit");
            return true;
        }
        URL uRL = this.zzh(zzst2);
        if (uRL == null) {
            this.zzbS("Failed to build collect POST endpoint url");
            return false;
        }
        return this.zza(uRL, byArray) == 200;
    }

    List<Long> zza(List<zzst> list, boolean bl) {
        zzac.zzas((!list.isEmpty() ? 1 : 0) != 0);
        this.zza("Uploading batched hits. compression, count", bl, list.size());
        zza zza2 = new zza();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (zzst zzst2 : list) {
            if (!zza2.zzj(zzst2)) break;
            arrayList.add(zzst2.zzpp());
        }
        if (zza2.zzpD() == 0) {
            return arrayList;
        }
        URL uRL = this.zzpB();
        if (uRL == null) {
            this.zzbS("Failed to build batching endpoint url");
            return Collections.emptyList();
        }
        int n = bl ? this.zzb(uRL, zza2.getPayload()) : this.zza(uRL, zza2.getPayload());
        if (200 == n) {
            this.zza("Batched upload completed. Hits batched", zza2.zzpD());
            return arrayList;
        }
        this.zza("Network error uploading hits. status code", n);
        if (this.zzns().zzoP().contains(n)) {
            this.zzbR("Server instructed the client to stop batching");
            this.zzafx.start();
        }
        return Collections.emptyList();
    }

    private URL zzh(zzst zzst2) {
        String string;
        if (zzst2.zzps()) {
            String string2 = String.valueOf(this.zzns().zzoJ());
            String string3 = String.valueOf(this.zzns().zzoL());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(this.zzns().zzoK());
            String string5 = String.valueOf(this.zzns().zzoL());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzb(zzst zzst2, String string) {
        String string2;
        String string3;
        if (zzst2.zzps()) {
            string3 = String.valueOf(this.zzns().zzoJ());
            String string4 = String.valueOf(this.zzns().zzoL());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = String.valueOf(this.zzns().zzoK());
            String string5 = String.valueOf(this.zzns().zzoL());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzpB() {
        String string = String.valueOf(this.zzns().zzoJ());
        String string2 = String.valueOf(this.zzns().zzoM());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    String zza(zzst zzst2, boolean bl) {
        zzac.zzw((Object)zzst2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzst2.zzfz().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                this.zza(stringBuilder, string, entry.getValue());
            }
            this.zza(stringBuilder, "ht", String.valueOf(zzst2.zzpq()));
            long l = this.zznq().currentTimeMillis() - zzst2.zzpq();
            this.zza(stringBuilder, "qt", String.valueOf(l));
            if (bl) {
                long l2 = zzst2.zzpt();
                String string = l2 != 0L ? String.valueOf(l2) : this.zzi(zzst2);
                this.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    private String zzi(zzst zzst2) {
        return String.valueOf(zzst2.zzpp());
    }

    private class zza {
        private int zzafz;
        private ByteArrayOutputStream zzafA = new ByteArrayOutputStream();

        public boolean zzj(zzst zzst2) {
            zzac.zzw((Object)zzst2);
            if (this.zzafz + 1 > zzsz.this.zzns().zzoH()) {
                return false;
            }
            String string = zzsz.this.zza(zzst2, false);
            if (string == null) {
                zzsz.this.zznr().zza(zzst2, "Error formatting hit");
                return true;
            }
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > zzsz.this.zzns().zzoz()) {
                zzsz.this.zznr().zza(zzst2, "Hit size exceeds the maximum size limit");
                return true;
            }
            if (this.zzafA.size() > 0) {
                ++n;
            }
            if (this.zzafA.size() + n > zzsz.this.zzns().zzoB()) {
                return false;
            }
            try {
                if (this.zzafA.size() > 0) {
                    this.zzafA.write(zzafy);
                }
                this.zzafA.write(byArray);
            }
            catch (IOException iOException) {
                zzsz.this.zze("Failed to write payload when batching hits", iOException);
                return true;
            }
            ++this.zzafz;
            return true;
        }

        public int zzpD() {
            return this.zzafz;
        }

        public byte[] getPayload() {
            return this.zzafA.toByteArray();
        }
    }
}

