/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.internal.zzrz;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsn;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

abstract class zzso<T extends zzsn>
extends zzrz {
    zza<T> zzaeY;

    public zzso(zzsc zzsc2, zza<T> zza2) {
        super(zzsc2);
        this.zzaeY = zza2;
    }

    public T zzaI(int n) {
        try {
            return this.zza(this.zznQ().zzod().getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzd("inflate() called with unknown resourceId", (Object)notFoundException);
            return null;
        }
    }

    private T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string;
                    String string2;
                    String string3 = xmlResourceParser.getName().toLowerCase();
                    if (string3.equals("screenname")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            this.zzaeY.zzp(string2, string);
                        }
                    } else if (string3.equals("string")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && string != null) {
                            this.zzaeY.zzq(string2, string);
                        }
                    } else if (string3.equals("bool")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string);
                                this.zzaeY.zze(string2, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing bool configuration value", string, numberFormatException);
                            }
                        }
                    } else if (string3.equals("integer")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                int n2 = Integer.parseInt(string);
                                this.zzaeY.zzd(string2, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing int configuration value", string, numberFormatException);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            this.zze("Error parsing tracker configuration file", (Object)xmlPullParserException);
        }
        catch (IOException iOException) {
            this.zze("Error parsing tracker configuration file", iOException);
        }
        return this.zzaeY.zzoV();
    }

    public static interface zza<U extends zzsn> {
        public void zzp(String var1, String var2);

        public void zzq(String var1, String var2);

        public void zze(String var1, boolean var2);

        public void zzd(String var1, int var2);

        public U zzoV();
    }
}

