/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsw;
import com.google.android.gms.internal.zztc;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.internal.zztl;
import com.google.android.gms.internal.zztn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzabG = new ArrayList<Runnable>();
    private boolean zztZ;
    private Set<zza> zzabH = new HashSet<zza>();
    private boolean zzabI;
    private boolean zzabJ;
    private volatile boolean zzabK;
    private boolean zzabL;

    public void initialize() {
        this.zzmw();
        this.zztZ = true;
    }

    void zzmw() {
        zztn zztn2 = this.zzmB();
        zztn2.zzpI();
        if (zztn2.zzpM()) {
            this.setDryRun(zztn2.zzpN());
        }
        zztn2.zzpI();
    }

    public boolean isInitialized() {
        return this.zztZ;
    }

    public GoogleAnalytics(zzsc zzsc2) {
        super(zzsc2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzsc.zzan(context).zzof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzmx() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzabG != null) {
                for (Runnable runnable : zzabG) {
                    runnable.run();
                }
                zzabG = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean bl) {
        this.zzabJ = bl;
    }

    public boolean isDryRunEnabled() {
        return this.zzabJ;
    }

    @TargetApi(value=14)
    public void enableAutoActivityReports(Application application) {
        if (!this.zzabI) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzabI = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzabI) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzabH) {
            zza2.zzo(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzabI) {
            this.zzn(activity);
        }
    }

    void zzn(Activity activity) {
        for (zza zza2 : this.zzabH) {
            zza2.zzp(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzmn(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zztk zztk2;
            zztl zztl2;
            Tracker tracker = new Tracker(this.zzmn(), null, null);
            if (n > 0 && (zztl2 = (zztl)(zztk2 = new zztk(this.zzmn())).zzaI(n)) != null) {
                tracker.zza(zztl2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzabH.add(zza2);
        Context context = this.zzmn().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzabH.remove(zza2);
    }

    public void setAppOptOut(boolean bl) {
        this.zzabK = bl;
        if (this.zzabK) {
            this.zzmA().zznK();
        }
    }

    public boolean getAppOptOut() {
        return this.zzabK;
    }

    @Deprecated
    public Logger getLogger() {
        return zztc.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zztc.setLogger(logger);
        if (!this.zzabL) {
            String string = zzsw.zzafl.get();
            Log.i((String)zzsw.zzafl.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzabL = true;
        }
    }

    public String zzmy() {
        zzac.zzdk((String)"getClientId can not be called from the main thread");
        return this.zzmn().zzoi().zzoQ();
    }

    public void setLocalDispatchPeriod(int n) {
        this.zzmA().setLocalDispatchPeriod(n);
    }

    public void dispatchLocalHits() {
        this.zzmA().zznL();
    }

    void zzmz() {
        this.zzmA().zznM();
    }

    private zzry zzmA() {
        return this.zzmn().zzmA();
    }

    private zztn zzmB() {
        return this.zzmn().zzmB();
    }

    @TargetApi(value=14)
    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzn(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzo(Activity var1);

        public void zzp(Activity var1);
    }
}

