/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zzth;
import com.google.android.gms.internal.zztm;

public final class zzti {
    private final Handler mHandler;
    private final zza zzagJ;
    private final Context mContext;
    private static Boolean zzaby;

    public zzti(zza zza2) {
        this.mContext = zza2.getContext();
        zzac.zzw((Object)this.mContext);
        this.zzagJ = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzal(Context context) {
        zzac.zzw((Object)context);
        if (zzaby != null) {
            return zzaby;
        }
        boolean bl = zztm.zzy(context, "com.google.android.gms.analytics.AnalyticsService");
        zzaby = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        zzsc zzsc2 = zzsc.zzan(this.mContext);
        zztd zztd2 = zzsc2.zznS();
        zztd2.zzbP("Local AnalyticsService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzsc zzsc2 = zzsc.zzan(this.mContext);
        zztd zztd2 = zzsc2.zznS();
        zztd2.zzbP("Local AnalyticsService is shutting down");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int n, final int n2) {
        this.zzmt();
        final zzsc zzsc2 = zzsc.zzan(this.mContext);
        final zztd zztd2 = zzsc2.zznS();
        if (intent == null) {
            zztd2.zzbS("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zztd2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            zzsc2.zzmA().zza(new zzsu(){

                @Override
                public void zzf(Throwable throwable) {
                    zzti.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzti.this.zzagJ.callServiceStopSelfResult(n2);
                            if (bl) {
                                zztd2.zzbP("Local AnalyticsService processed last dispatch request");
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmt() {
        try {
            Object object = zzth.zztX;
            synchronized (object) {
                zzbay zzbay2 = zzth.zzabw;
                if (zzbay2 != null && zzbay2.isHeld()) {
                    zzbay2.release();
                }
            }
        }
        catch (SecurityException securityException) {}
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

