/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzapn;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzadA;
    private final Tracker zzadB;
    private final Context mContext;
    private ExceptionParser zzadC;
    private GoogleAnalytics zzadD;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzadA = uncaughtExceptionHandler;
        this.zzadB = tracker;
        this.zzadC = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzapn.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzadC;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzadC = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzadC != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzadC.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzapn.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzadB.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zzadD == null) {
            exceptionReporter.zzadD = GoogleAnalytics.getInstance(exceptionReporter.mContext);
        }
        object = exceptionReporter.zzadD;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zzjh().zzku().zzkl();
        if (this.zzadA != null) {
            zzapn.v("Passing exception to the original handler");
            this.zzadA.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zzjm() {
        return this.zzadA;
    }
}

