/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzapm;
import com.google.android.gms.internal.zzapo;
import com.google.android.gms.internal.zzaqd;
import com.google.android.gms.internal.zzaqe;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzant {
    private boolean zzaeq;
    private final Map<String, String> zzHd = new HashMap<String, String>();
    private final Map<String, String> zzaer = new HashMap<String, String>();
    private final zzapm zzaes;
    private final zza zzaet;
    private ExceptionReporter zzaeu;
    private zzaqd zzaev;

    Tracker(zzanv zzanv2, String string, zzapm zzapm2) {
        super(zzanv2);
        if (string != null) {
            this.zzHd.put("&tid", string);
        }
        this.zzHd.put("useSecure", "1");
        this.zzHd.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzaes = new zzapm("tracking", this.zzkp());
        this.zzaet = new zza(this, zzanv2);
    }

    @Override
    protected final void zzjC() {
        String string;
        this.zzaet.initialize();
        String string2 = this.zzkw().zzjF();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzkw().zzjG()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzaqd zzaqd2) {
        String string;
        this.zzbo("Loading Tracker config values");
        this.zzaev = zzaqd2;
        if (this.zzaev.zzadq != null) {
            string = this.zzaev.zzadq;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzaev.zzaiK >= 0.0) {
            string = Double.toString(this.zzaev.zzaiK);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzaev.zzaiL >= 0) {
            int n = this.zzaev.zzaiL;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzaev.zzaiM != -1) {
            boolean bl = this.zzaev.zzaiM == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzaev.zzaiN != -1) {
            boolean bl = this.zzaev.zzaiN == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzaev.zzaiO == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzaeu != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzaeu = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzaeu);
                this.zzbo("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzaeu.zzjm());
                this.zzbo("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzaet.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzaet.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        Map.Entry<String, String> entry2 = entry;
        String string = entry2.getKey();
        entry2.getValue();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbr.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbr.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzkp().currentTimeMillis();
        if (this.zzkt().getAppOptOut()) {
            this.zzbp("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzkt().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzHd, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzaqe.zzf(this.zzHd.get("useSecure"), true);
        Tracker.zzc(this.zzaer, hashMap);
        this.zzaer.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzkq().zze(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzkq().zze(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzaeq;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzHd.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzHd.put("&a", Integer.toString(n));
            }
        }
        this.zzks().zzf(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzkC();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzHd.containsKey(string)) {
            return this.zzHd.get(string);
        }
        if (string.equals("&ul")) {
            return zzaqe.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzky().zzlh();
        }
        if (string.equals("&sr")) {
            return this.zzkB().zzlA();
        }
        if (string.equals("&aid")) {
            return this.zzkA().zzkV().zzhk();
        }
        if (string.equals("&an")) {
            return this.zzkA().zzkV().zzjF();
        }
        if (string.equals("&av")) {
            return this.zzkA().zzkV().zzjG();
        }
        if (string.equals("&aiid")) {
            return this.zzkA().zzkV().zzjH();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbr.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzHd.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzaqe.zzI(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzbr("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzaqe.zzI(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzaer.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzaer.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzaer.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzaer.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzaer.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzaer.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzaer.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzaer.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzaer.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzaer.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzaeq = bl;
    }

    static /* synthetic */ zzanj zzb(Tracker tracker) {
        return tracker.zzkz();
    }

    static /* synthetic */ zzaog zzc(Tracker tracker) {
        return tracker.zzkA();
    }

    static /* synthetic */ zzapa zzd(Tracker tracker) {
        return tracker.zzkB();
    }

    static /* synthetic */ zzapa zze(Tracker tracker) {
        return tracker.zzkB();
    }

    static /* synthetic */ zzapm zzf(Tracker tracker) {
        return tracker.zzaes;
    }

    static /* synthetic */ zzapo zzg(Tracker tracker) {
        return tracker.zzkq();
    }

    static /* synthetic */ zzapo zzh(Tracker tracker) {
        return tracker.zzkq();
    }

    static /* synthetic */ zzank zzi(Tracker tracker) {
        return tracker.zzku();
    }

    static /* synthetic */ zzank zzj(Tracker tracker) {
        return tracker.zzku();
    }

    final class zza
    extends zzant
    implements GoogleAnalytics.zza {
        private boolean zzaeE;
        private int zzaeF;
        private long zzaeG;
        private boolean zzaeH;
        private long zzaeI;
        private /* synthetic */ Tracker zzaeD;

        protected zza(Tracker tracker, zzanv zzanv2) {
            this.zzaeD = tracker;
            super(zzanv2);
            this.zzaeG = -1L;
        }

        @Override
        protected final void zzjC() {
        }

        public final void setSessionTimeout(long l) {
            this.zzaeG = l;
            this.zzjE();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzaeE = bl;
            this.zzjE();
        }

        public final synchronized boolean zzjD() {
            boolean bl = this.zzaeH;
            this.zzaeH = false;
            return bl;
        }

        private final void zzjE() {
            if (this.zzaeG >= 0L || this.zzaeE) {
                this.zzkt().zza(this.zzaeD.zzaet);
                return;
            }
            this.zzkt().zzb(this.zzaeD.zzaet);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzaeF == 0 && (zza2 = this).zzkp().elapsedRealtime() >= zza2.zzaeI + Math.max(1000L, zza2.zzaeG)) {
                this.zzaeH = true;
            }
            ++this.zzaeF;
            if (this.zzaeE) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzaeD.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzaeD.set("&cd", this.zzaeD.zzaev != null ? ((string2 = ((Tracker)this.zzaeD).zzaev.zzaiP.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbr.zzu((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzaeD.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzaeF;
            this.zzaeF = Math.max(0, this.zzaeF);
            if (this.zzaeF == 0) {
                this.zzaeI = this.zzkp().elapsedRealtime();
            }
        }
    }
}

