/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzana;
import com.google.android.gms.internal.zzanf;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaoj;
import com.google.android.gms.internal.zzaok;
import com.google.android.gms.internal.zzaol;
import com.google.android.gms.internal.zzaow;
import com.google.android.gms.internal.zzaoy;
import com.google.android.gms.internal.zzapb;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzapj;
import com.google.android.gms.internal.zzapp;
import com.google.android.gms.internal.zzapq;
import com.google.android.gms.internal.zzapv;
import com.google.android.gms.internal.zzapw;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqe;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzbim;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzaoh
extends zzant {
    private boolean mStarted;
    private final zzaoe zzagx;
    private final zzapq zzagy;
    private final zzapp zzagz;
    private final zzanz zzagA;
    private long zzagB;
    private final zzaoy zzagC;
    private final zzaoy zzagD;
    private final zzaqa zzagE;
    private long zzagF;
    private boolean zzagG;

    protected zzaoh(zzanv zzanv2, zzanx zzanx2) {
        super(zzanv2);
        zzbr.zzu((Object)zzanx2);
        this.zzagB = Long.MIN_VALUE;
        zzanv zzanv3 = zzanv2;
        this.zzagz = new zzapp(zzanv3);
        zzanv3 = zzanv2;
        this.zzagx = new zzaoe(zzanv3);
        zzanv3 = zzanv2;
        this.zzagy = new zzapq(zzanv3);
        zzanv3 = zzanv2;
        this.zzagA = new zzanz(zzanv3);
        this.zzagE = new zzaqa(this.zzkp());
        this.zzagC = new zzaoi(this, zzanv2);
        this.zzagD = new zzaoj(this, zzanv2);
    }

    @Override
    protected final void zzjC() {
        this.zzagx.initialize();
        this.zzagy.initialize();
        this.zzagA.initialize();
    }

    final void start() {
        this.zzkC();
        zzbr.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzks().zzf(new zzaok(this));
    }

    private final boolean zzbv(String string) {
        return zzbim.zzaP((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzkW() {
        this.zzkC();
        zzaoh zzaoh2 = this;
        zzl.zzjB();
        Context context = zzaoh2.zzko().getContext();
        if (!zzapv.zzac(context)) {
            zzaoh2.zzbr("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzapw.zzad(context)) {
            zzaoh2.zzbs("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzac(context)) {
            zzaoh2.zzbr("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!CampaignTrackingService.zzad(context)) {
            zzaoh2.zzbr("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzkx().zzlS();
        if (!this.zzbv("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbs("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlg();
        }
        if (!this.zzbv("android.permission.INTERNET")) {
            this.zzbs("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlg();
        }
        if (zzapw.zzad(this.getContext())) {
            this.zzbo("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzbr("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzagG && !this.zzagx.isEmpty()) {
            this.zzkZ();
        }
        this.zzlc();
    }

    private final void zzkX() {
        this.zzb(new zzaol(this));
    }

    final void zzkn() {
        zzl.zzjB();
        this.zzagF = this.zzkp().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzl.zzjB();
        zzaoh zzaoh2 = this;
        zzl.zzjB();
        zzaoh2.zzkC();
        if (!zzaow.zzln()) {
            zzaoh2.zzbr("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzaoh2.zzagA.isConnected()) {
            zzaoh2.zzbo("Service not connected");
            return;
        }
        if (!zzaoh2.zzagx.isEmpty()) {
            zzaoh2.zzbo("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzapj> list;
                try {
                    list = zzaoh2.zzagx.zzo(zzaow.zzlr());
                    if (list.isEmpty()) {
                        zzaoh2.zzlc();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzaoh2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzaoh2.zzle();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzapj zzapj2 = list.get(0);
                    if (!zzaoh2.zzagA.zzb(zzapj2)) {
                        zzaoh2.zzlc();
                        return;
                    }
                    list.remove(zzapj2);
                    try {
                        zzaoh2.zzagx.zzp(zzapj2.zzlE());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzaoh2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzaoh2.zzle();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzkY() {
        try {
            this.zzagx.zzkR();
            this.zzlc();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzagD.zzs(86400000L);
    }

    protected final void zzb(zzany zzany2) {
        zzl.zzjB();
        this.zzb("Sending first hit to property", zzany2.zzkK());
        if (this.zzkx().zzlT().zzu(zzaow.zzlx())) {
            return;
        }
        String string = this.zzkx().zzlW();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzamx zzamx2 = zzaqe.zza(this.zzkq(), string);
        this.zzb("Found relevant installation campaign", zzamx2);
        this.zza(zzany2, zzamx2);
    }

    public final void zzr(long l) {
        zzl.zzjB();
        this.zzkC();
        if (l < 0L) {
            l = 0L;
        }
        this.zzagB = l;
        this.zzlc();
    }

    private final void zzkZ() {
        if (this.zzagG) {
            return;
        }
        if (!zzaow.zzln()) {
            return;
        }
        if (this.zzagA.isConnected()) {
            return;
        }
        long l = zzape.zzahU.get();
        if (this.zzagE.zzu(l)) {
            this.zzagE.start();
            this.zzbo("Connecting to service");
            if (this.zzagA.connect()) {
                this.zzbo("Connected to service");
                this.zzagE.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzany zzany2, boolean bl) {
        long l;
        zzbr.zzu((Object)zzany2);
        this.zzkC();
        zzl.zzjB();
        try {
            this.zzagx.beginTransaction();
            String string = zzany2.zzjW();
            long l2 = zzany2.zzkJ();
            zzaoe zzaoe2 = this.zzagx;
            zzbr.zzcF((String)string);
            zzaoe2.zzkC();
            zzl.zzjB();
            int n = zzaoe2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzaoe2.zza("Deleted property records", n);
            }
            l = this.zzagx.zza(zzany2.zzkJ(), zzany2.zzjW(), zzany2.zzkK());
            zzany2.zzm(l + 1L);
            zzany zzany3 = zzany2;
            zzaoe zzaoe3 = this.zzagx;
            zzbr.zzu((Object)zzany3);
            zzaoe3.zzkC();
            zzl.zzjB();
            SQLiteDatabase sQLiteDatabase = zzaoe3.getWritableDatabase();
            Map<String, String> map = zzany3.zzdU();
            zzbr.zzu(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzany3.zzkJ()));
            contentValues.put("cid", zzany3.zzjW());
            contentValues.put("tid", zzany3.zzkK());
            contentValues.put("adid", Integer.valueOf(zzany3.zzkL() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzany3.zzkM()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzaoe3.zzbs("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzaoe3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzagx.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzagx.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzapj zzapj2) {
        zzapj zzapj3;
        zzbr.zzu((Object)zzapj2);
        zzl.zzjB();
        this.zzkC();
        if (this.zzagG) {
            this.zzbp("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzapj2);
        }
        zzapj zzapj4 = zzapj2;
        zzaoh zzaoh2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzapj4.zzlJ())) {
            zzapj3 = zzapj4;
        } else {
            Pair<String, Long> pair = zzaoh2.zzkx().zzlX().zzlZ();
            if (pair == null) {
                zzapj3 = zzapj4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzapj4.zzdU());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzapj zzapj5 = zzapj4;
                zzaoh zzaoh3 = zzaoh2;
                zzapj3 = new zzapj(zzaoh3, (Map<String, String>)object2, zzapj5.zzlF(), zzapj5.zzlH(), zzapj5.zzlE(), zzapj5.zzlD(), zzapj5.zzlG());
            }
        }
        zzapj2 = zzapj3;
        this.zzkZ();
        if (this.zzagA.zzb(zzapj2)) {
            this.zzbp("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzagx.zzc(zzapj2);
            this.zzlc();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzkq().zza(zzapj2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzkj() {
        zzl.zzjB();
        this.zzkC();
        this.zzbo("Delete all hits from local store");
        try {
            zzaoe zzaoe2 = this.zzagx;
            zzl.zzjB();
            zzaoe2.zzkC();
            zzaoe2.getWritableDatabase().delete("hits2", null, null);
            zzaoe2 = this.zzagx;
            zzl.zzjB();
            zzaoe2.zzkC();
            zzaoe2.getWritableDatabase().delete("properties", null, null);
            this.zzlc();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzkZ();
        if (this.zzagA.zzkN()) {
            this.zzbo("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzla() {
        boolean bl;
        zzl.zzjB();
        this.zzkC();
        this.zzbo("Dispatching a batch of local hits");
        boolean bl2 = !this.zzagA.isConnected();
        boolean bl3 = bl = !this.zzagy.zzlP();
        if (bl2 && bl) {
            this.zzbo("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzaow.zzlr(), zzaow.zzls());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzapj> list;
                block38: {
                    this.zzagx.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzagx.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbo("Store is empty, nothing to dispatch");
                        this.zzle();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzle();
                        try {
                            this.zzagx.setTransactionSuccessful();
                            this.zzagx.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzle();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzlE() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzle();
                    return false;
                }
                if (this.zzagA.isConnected()) {
                    this.zzbo("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzagA.zzb((zzapj)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzapj)((Object)list2)).zzlE());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzagx.zzp(((zzapj)((Object)list2)).zzlE());
                            arrayList.add(((zzapj)((Object)list2)).zzlE());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzle();
                            try {
                                this.zzagx.setTransactionSuccessful();
                                this.zzagx.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzle();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzagy.zzlP()) {
                    list2 = this.zzagy.zzu(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzagx.zzs(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzle();
                        try {
                            this.zzagx.setTransactionSuccessful();
                            this.zzagx.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzle();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzagx.setTransactionSuccessful();
                    this.zzagx.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzle();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzapc zzapc2) {
        long l = this.zzagF;
        zzapc zzapc3 = zzapc2;
        zzaoh zzaoh2 = this;
        zzl.zzjB();
        zzaoh2.zzkC();
        long l2 = -1L;
        long l3 = zzaoh2.zzkx().zzlU();
        if (l3 != 0L) {
            l2 = Math.abs(zzaoh2.zzkp().currentTimeMillis() - l3);
        }
        zzaoh2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzaoh2.zzkZ();
        try {
            zzaoh2.zzla();
            zzaoh2.zzkx().zzlV();
            zzaoh2.zzlc();
            if (zzapc3 != null) {
                zzapc3.zzc(null);
            }
            if (zzaoh2.zzagF != l) {
                zzaoh2.zzagz.zzlO();
            }
            return;
        }
        catch (Throwable throwable) {
            zzaoh2.zze("Local dispatch failed", throwable);
            zzaoh2.zzkx().zzlV();
            zzaoh2.zzlc();
            if (zzapc3 != null) {
                zzapc3.zzc(throwable);
            }
            return;
        }
    }

    public final void zzlb() {
        zzl.zzjB();
        this.zzkC();
        this.zzbp("Sync dispatching local hits");
        long l = this.zzagF;
        this.zzkZ();
        try {
            this.zzla();
            this.zzkx().zzlV();
            this.zzlc();
            if (this.zzagF != l) {
                this.zzagz.zzlO();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzlc();
            return;
        }
    }

    private final long zzkS() {
        zzl.zzjB();
        this.zzkC();
        try {
            return this.zzagx.zzkS();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzlc() {
        boolean bl;
        zzl.zzjB();
        this.zzkC();
        zzaoh zzaoh2 = this;
        if (!(!zzaoh2.zzagG && zzaoh2.zzlf() > 0L)) {
            this.zzagz.unregister();
            this.zzle();
            return;
        }
        if (this.zzagx.isEmpty()) {
            this.zzagz.unregister();
            this.zzle();
            return;
        }
        if (!zzape.zzahP.get().booleanValue()) {
            this.zzagz.zzlM();
            bl = this.zzagz.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzaoh2 = this;
            zzaoh2.zzld();
            long l3 = zzaoh2.zzlf();
            long l4 = zzaoh2.zzkx().zzlU();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzaoh2.zzkp().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzaow.zzlp(), l3)) : Math.min(zzaow.zzlp(), l3);
            zzaoh2.zza("Dispatch scheduled (ms)", l5);
            if (zzaoh2.zzagC.zzbn()) {
                l = Math.max(1L, l5 + zzaoh2.zzagC.zzly());
                zzaoh2.zzagC.zzt(l);
                return;
            }
            zzaoh2.zzagC.zzs(l5);
            return;
        }
        this.zzle();
        this.zzld();
    }

    private final void zzld() {
        long l;
        zzapb zzapb2 = this.zzkv();
        if (!zzapb2.zzlB()) {
            return;
        }
        if (!zzapb2.zzbn() && (l = this.zzkS()) != 0L && Math.abs(this.zzkp().currentTimeMillis() - l) <= zzape.zzaht.get()) {
            long l2 = zzaow.zzlq();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzapb2.schedule();
        }
    }

    private final void zzle() {
        zzaoh zzaoh2 = this;
        if (zzaoh2.zzagC.zzbn()) {
            zzaoh2.zzbo("All hits dispatched or no network/service. Going to power save mode");
        }
        zzaoh2.zzagC.cancel();
        zzapb zzapb2 = this.zzkv();
        if (zzapb2.zzbn()) {
            zzapb2.cancel();
        }
    }

    private final long zzlf() {
        if (this.zzagB != Long.MIN_VALUE) {
            return this.zzagB;
        }
        long l = zzape.zzaho.get();
        zzaqf zzaqf2 = this.zzkw();
        zzaqf2.zzkC();
        if (zzaqf2.zzaiR) {
            zzaqf2 = this.zzkw();
            zzaqf2.zzkC();
            l = (long)zzaqf2.zzaib * 1000L;
        }
        return l;
    }

    public final void zzbw(String string) {
        zzbr.zzcF((String)string);
        zzl.zzjB();
        zzamx zzamx2 = zzaqe.zza(this.zzkq(), string);
        if (zzamx2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzkx().zzlW();
        if (string.equals(string2)) {
            this.zzbr("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzkx().zzbz(string);
        if (this.zzkx().zzlT().zzu(zzaow.zzlx())) {
            this.zzd("Campaign received too late, ignoring", zzamx2);
            return;
        }
        this.zzb("Received installation campaign", zzamx2);
        for (zzany zzany2 : this.zzagx.zzq(0L)) {
            this.zza(zzany2, zzamx2);
        }
    }

    private final void zza(zzany zzany2, zzamx zzamx2) {
        zzbr.zzu((Object)zzany2);
        zzbr.zzu((Object)zzamx2);
        zza zza2 = new zza(this.zzko());
        zza2.zzaY(zzany2.zzkK());
        zza2.enableAdvertisingIdCollection(zzany2.zzkL());
        zzi zzi2 = zza2.zzji();
        zzanf zzanf2 = zzi2.zzb(zzanf.class);
        zzanf2.zzbj("data");
        zzanf2.zzH(true);
        zzi2.zza(zzamx2);
        zzana zzana2 = zzi2.zzb(zzana.class);
        zzamw zzamw2 = zzi2.zzb(zzamw.class);
        for (Map.Entry<String, String> entry : zzany2.zzdU().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzamw2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzamw2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzamw2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzamw2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzanf2.setUserId(string2);
                continue;
            }
            zzana2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzany2.zzkK(), zzamx2);
        zzi2.zzl(this.zzkx().zzlS());
        zzi2.zzjs();
    }

    private final void zzlg() {
        this.zzkC();
        zzl.zzjB();
        this.zzagG = true;
        this.zzagA.disconnect();
        this.zzlc();
    }

    static /* synthetic */ void zza(zzaoh zzaoh2) {
        zzaoh2.zzkX();
    }

    static /* synthetic */ void zzb(zzaoh zzaoh2) {
        zzaoh2.zzkY();
    }
}

