/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzanv;

class zzapp
extends BroadcastReceiver {
    private static String zzais = zzapp.class.getName();
    private final zzanv zzafL;
    private boolean mRegistered;
    private boolean zzait;

    zzapp(zzanv zzanv2) {
        zzbr.zzu((Object)zzanv2);
        this.zzafL = zzanv2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzlN();
        String string = intent.getAction();
        this.zzafL.zzkq().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzlP();
            if (this.zzait != bl) {
                this.zzait = bl;
                boolean bl2 = bl;
                zzank zzank2 = this.zzafL.zzku();
                zzank2.zza("Network connectivity status changed", bl2);
                zzank2.zzks().zzf(new zzanm(zzank2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzais)) {
                zzank zzank3 = this.zzafL.zzku();
                zzank3.zzbo("Radio powered up");
                zzank3.zzkk();
            }
            return;
        }
        this.zzafL.zzkq().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzlM() {
        this.zzlN();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzafL.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzait = this.zzlP();
        this.zzafL.zzkq().zza("Registering connectivity change receiver. Network connected", this.zzait);
        this.mRegistered = true;
    }

    private final void zzlN() {
        this.zzafL.zzkq();
        this.zzafL.zzku();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzafL.zzkq().zzbo("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzait = false;
        Context context = this.zzafL.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzafL.zzkq().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzlO() {
        Context context = this.zzafL.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzais, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzafL.zzkq().zzbr("Connectivity unknown. Receiver not registered");
        }
        return this.zzait;
    }

    private final boolean zzlP() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzafL.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

