/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzaoo;
import java.util.Collections;
import java.util.List;

public final class zzamn
extends zzamh {
    private final zzamp zzagg;
    private zzany zzagh;
    private final zzanm zzagi;
    private zzaoo zzagj;

    protected zzamn(zzamj zzamj2) {
        super(zzamj2);
        this.zzagj = new zzaoo(zzamj2.zzkq());
        this.zzagg = new zzamp(this);
        this.zzagi = new zzamo(this, zzamj2);
    }

    @Override
    protected final void zzjD() {
    }

    public final boolean isConnected() {
        zzl.zzjC();
        this.zzkD();
        return this.zzagh != null;
    }

    public final boolean zzb(zzanx zzanx2) {
        zzbo.zzu((Object)zzanx2);
        zzl.zzjC();
        this.zzkD();
        zzany zzany2 = this.zzagh;
        if (zzany2 == null) {
            return false;
        }
        String string = zzanx2.zzlI() ? zzank.zzlu() : zzank.zzlv();
        List<zzane> list = Collections.emptyList();
        try {
            zzany2.zza(zzanx2.zzdV(), zzanx2.zzlG(), string, list);
            this.zzkP();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbo("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzkO() {
        zzl.zzjC();
        this.zzkD();
        zzany zzany2 = this.zzagh;
        if (zzany2 == null) {
            return false;
        }
        try {
            zzany2.zzkk();
            this.zzkP();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbo("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzkP() {
        this.zzagj.start();
        this.zzagi.zzs(zzans.zzahO.get());
    }

    public final boolean connect() {
        zzl.zzjC();
        this.zzkD();
        if (this.zzagh != null) {
            return true;
        }
        zzany zzany2 = this.zzagg.zzkR();
        if (zzany2 != null) {
            this.zzagh = zzany2;
            this.zzkP();
            return true;
        }
        return false;
    }

    private final void zza(zzany zzany2) {
        zzl.zzjC();
        this.zzagh = zzany2;
        this.zzkP();
        this.zzkv().onServiceConnected();
    }

    public final void disconnect() {
        zzl.zzjC();
        this.zzkD();
        try {
            zza.zzrU();
            zzamp zzamp2 = this.zzagg;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzamp2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzagh != null) {
            this.zzagh = null;
            this.zzkv().zzkn();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzl.zzjC();
        if (this.zzagh != null) {
            this.zzagh = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzkv().zzkn();
        }
    }

    private final void zzkQ() {
        zzl.zzjC();
        if (!this.isConnected()) {
            return;
        }
        this.zzbo("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzamp zza(zzamn zzamn2) {
        return zzamn2.zzagg;
    }

    static /* synthetic */ void zza(zzamn zzamn2, zzany zzany2) {
        zzamn2.zza(zzany2);
    }

    static /* synthetic */ void zza(zzamn zzamn2, ComponentName componentName) {
        zzamn2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzamn zzamn2) {
        zzamn2.zzkQ();
    }
}

