/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzaoc;
import com.google.android.gms.internal.zzaol;
import com.google.android.gms.internal.zzaoz;
import com.google.android.gms.internal.zzapb;
import com.google.android.gms.internal.zzapd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzdkb = new ArrayList<Runnable>();
    private boolean zzaqo;
    private Set<zza> zzdkc = new HashSet<zza>();
    private boolean zzdkd;
    private boolean zzdke;
    private volatile boolean zzdkf;
    private boolean zzdkg;

    public final void initialize() {
        GoogleAnalytics googleAnalytics = this;
        zzapd zzapd2 = googleAnalytics.zztn().zzwb();
        zzapd2.zzzk();
        if (zzapd2.zzzl()) {
            googleAnalytics.setDryRun(zzapd2.zzzm());
        }
        zzapd2.zzzk();
        this.zzaqo = true;
    }

    public final boolean isInitialized() {
        return this.zzaqo;
    }

    public GoogleAnalytics(zzamt zzamt2) {
        super(zzamt2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzamt.zzbi(context).zzwk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zztt() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzdkb != null) {
                Iterator<Runnable> iterator = zzdkb.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzdkb = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzdke = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzdke;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzdkd) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(this));
            this.zzdkd = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzdkd) {
            this.zzj(activity);
        }
    }

    final void zzj(Activity activity) {
        Iterator<zza> iterator = this.zzdkc.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzl(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzdkd) {
            this.zzk(activity);
        }
    }

    final void zzk(Activity activity) {
        Iterator<zza> iterator = this.zzdkc.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzm(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zztn(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzapb zzapb2;
            Tracker tracker = new Tracker(this.zztn(), null, null);
            if (n > 0 && (zzapb2 = (zzapb)new zzaoz(this.zztn()).zzat(n)) != null) {
                tracker.zza(zzapb2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzdkc.add(zza2);
        Context context = this.zztn().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzdkc.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzdkf = bl;
        if (this.zzdkf) {
            this.zztn().zzvz().zzvo();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzdkf;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzaol.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzaol.setLogger(logger);
        if (!this.zzdkg) {
            String string = zzaoc.zzdrf.get();
            Log.i((String)zzaoc.zzdrf.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzdkg = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zztn().zzvz().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zztn().zzvz().zzvp();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        private /* synthetic */ GoogleAnalytics zzdkh;

        zzb(GoogleAnalytics googleAnalytics) {
            this.zzdkh = googleAnalytics;
        }

        public final void onActivityStarted(Activity activity) {
            this.zzdkh.zzj(activity);
        }

        public final void onActivityStopped(Activity activity) {
            this.zzdkh.zzk(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzl(Activity var1);

        public void zzm(Activity var1);
    }
}

