/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzaoy;
import com.google.android.gms.internal.zzapc;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public final class zzamh
extends zzamr {
    private static boolean zzdnu;
    private AdvertisingIdClient.Info zzdnv;
    private final zzaoy zzdnw;
    private String zzdnx;
    private boolean zzdny = false;
    private Object zzdnz = new Object();

    zzamh(zzamt zzamt2) {
        super(zzamt2);
        this.zzdnw = new zzaoy(zzamt2.zzvu());
    }

    @Override
    protected final void zzuh() {
    }

    public final boolean zzvd() {
        this.zzwh();
        AdvertisingIdClient.Info info = this.zzvl();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzvk() {
        this.zzwh();
        AdvertisingIdClient.Info info = this.zzvl();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzvl() {
        if (this.zzdnw.zzu(1000L)) {
            this.zzdnw.start();
            AdvertisingIdClient.Info info = this.zzvm();
            if (this.zza(this.zzdnv, info)) {
                this.zzdnv = info;
            } else {
                this.zzdr("Failed to reset client id on adid change. Not using adid");
                this.zzdnv = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzdnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzwd().zzxm();
        Object object = this.zzdnz;
        synchronized (object) {
            String string3;
            if (!this.zzdny) {
                this.zzdnx = this.zzvn();
                this.zzdny = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzdnx)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzdm(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzdnx = zzamh.zzdl(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzamh.zzdl(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzdnx)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdnx)) {
                this.zzdn("Resetting the client id because Advertising Id changed.");
                string2 = this.zzwd().zzxn();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzdm(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzvm() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzdq("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzdnu) break block3;
                zzdnu = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzdl(String string) {
        MessageDigest messageDigest = zzapc.zzed("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzdm(String string) {
        try {
            String string2 = zzamh.zzdl(string);
            this.zzdn("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzdnx = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzvn() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzdq("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzdn("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

