/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamk;
import com.google.android.gms.internal.zzamt;

class zzaon
extends BroadcastReceiver {
    private static String zzdtp = zzaon.class.getName();
    private final zzamt zzdoi;
    private boolean mRegistered;
    private boolean zzdtq;

    zzaon(zzamt zzamt2) {
        zzbp.zzu((Object)zzamt2);
        this.zzdoi = zzamt2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzys();
        String string = intent.getAction();
        this.zzdoi.zzvv().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzyu();
            if (this.zzdtq != bl) {
                this.zzdtq = bl;
                boolean bl2 = bl;
                zzami zzami2 = this.zzdoi.zzvz();
                zzami2.zza("Network connectivity status changed", bl2);
                zzami2.zzvx().zzc(new zzamk(zzami2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzdtp)) {
                zzami zzami3 = this.zzdoi.zzvz();
                zzami3.zzdn("Radio powered up");
                zzami3.zzvp();
            }
            return;
        }
        this.zzdoi.zzvv().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzyr() {
        this.zzys();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdoi.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzdtq = this.zzyu();
        this.zzdoi.zzvv().zza("Registering connectivity change receiver. Network connected", this.zzdtq);
        this.mRegistered = true;
    }

    private final void zzys() {
        this.zzdoi.zzvv();
        this.zzdoi.zzvz();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdoi.zzvv().zzdn("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzdtq = false;
        Context context = this.zzdoi.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdoi.zzvv().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzyt() {
        Context context = this.zzdoi.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzdtp, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdoi.zzvv().zzdq("Connectivity unknown. Receiver not registered");
        }
        return this.zzdtq;
    }

    private final boolean zzyu() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdoi.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

