/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzanf;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaol;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzapd;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzams {
    private boolean zzdlh;
    private final Map<String, String> zzbql = new HashMap<String, String>();
    private final Map<String, String> zzdli = new HashMap<String, String>();
    private final zzaol zzdlj;
    private final zza zzdlk;
    private ExceptionReporter zzdll;
    private zzapc zzdlm;

    Tracker(zzamu zzamu2, String string, zzaol zzaol2) {
        super(zzamu2);
        if (string != null) {
            this.zzbql.put("&tid", string);
        }
        this.zzbql.put("useSecure", "1");
        this.zzbql.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzdlj = new zzaol("tracking", this.zzvx());
        this.zzdlk = new zza(this, zzamu2);
    }

    @Override
    protected final void zzuk() {
        String string;
        this.zzdlk.initialize();
        String string2 = this.zzwe().zzun();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzwe().zzuo()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzapc zzapc2) {
        String string;
        this.zzdm("Loading Tracker config values");
        this.zzdlm = zzapc2;
        if (this.zzdlm.zzdjn != null) {
            string = this.zzdlm.zzdjn;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzdlm.zzduf >= 0.0) {
            string = Double.toString(this.zzdlm.zzduf);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzdlm.zzdug >= 0) {
            int n = this.zzdlm.zzdug;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzdlm.zzduh != -1) {
            boolean bl = this.zzdlm.zzduh == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzdlm.zzdui != -1) {
            boolean bl = this.zzdlm.zzdui == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzdlm.zzduj == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzdll != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzdll = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzdll);
                this.zzdm("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzdll.zztv());
                this.zzdm("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzdlk.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzdlk.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbp.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbp.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzvx().currentTimeMillis();
        if (this.zzwb().getAppOptOut()) {
            this.zzdn("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzwb().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbql, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzapd.zzd(this.zzbql.get("useSecure"), true);
        Tracker.zzc(this.zzdli, hashMap);
        this.zzdli.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzvy().zze(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzvy().zze(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzdlh;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbql.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbql.put("&a", Integer.toString(n));
            }
        }
        this.zzwa().zzc(new zzn(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbql.containsKey(string)) {
            return this.zzbql.get(string);
        }
        if (string.equals("&ul")) {
            return zzapd.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzwg().zzxp();
        }
        if (string.equals("&sr")) {
            return this.zzwj().zzyi();
        }
        if (string.equals("&aid")) {
            return this.zzwi().zzxd().getAppId();
        }
        if (string.equals("&an")) {
            return this.zzwi().zzxd().zzun();
        }
        if (string.equals("&av")) {
            return this.zzwi().zzxd().zzuo();
        }
        if (string.equals("&aiid")) {
            return this.zzwi().zzxd().zzup();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbp.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbql.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzapd.zzaj(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzdp("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzapd.zzaj(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzdli.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzdli.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzdli.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzdli.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzdli.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzdli.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzdli.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzdli.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzdli.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzdli.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzdlh = bl;
    }

    static /* synthetic */ zzami zzb(Tracker tracker) {
        return tracker.zzwh();
    }

    static /* synthetic */ zzanf zzc(Tracker tracker) {
        return tracker.zzwi();
    }

    static /* synthetic */ zzanz zzd(Tracker tracker) {
        return tracker.zzwj();
    }

    static /* synthetic */ zzanz zze(Tracker tracker) {
        return tracker.zzwj();
    }

    static /* synthetic */ zzaol zzf(Tracker tracker) {
        return tracker.zzdlj;
    }

    static /* synthetic */ zzaon zzg(Tracker tracker) {
        return tracker.zzvy();
    }

    static /* synthetic */ zzaon zzh(Tracker tracker) {
        return tracker.zzvy();
    }

    static /* synthetic */ zzamj zzi(Tracker tracker) {
        return tracker.zzwc();
    }

    static /* synthetic */ zzamj zzj(Tracker tracker) {
        return tracker.zzwc();
    }

    final class zza
    extends zzams
    implements GoogleAnalytics.zza {
        private boolean zzdlv;
        private int zzdlw;
        private long zzdlx;
        private boolean zzdly;
        private long zzdlz;
        private /* synthetic */ Tracker zzdlu;

        protected zza(Tracker tracker, zzamu zzamu2) {
            this.zzdlu = tracker;
            super(zzamu2);
            this.zzdlx = -1L;
        }

        @Override
        protected final void zzuk() {
        }

        public final void setSessionTimeout(long l) {
            this.zzdlx = l;
            this.zzum();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzdlv = bl;
            this.zzum();
        }

        public final synchronized boolean zzul() {
            boolean bl = this.zzdly;
            this.zzdly = false;
            return bl;
        }

        private final void zzum() {
            if (this.zzdlx >= 0L || this.zzdlv) {
                this.zzwb().zza(this.zzdlu.zzdlk);
                return;
            }
            this.zzwb().zzb(this.zzdlu.zzdlk);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzdlw == 0 && (zza2 = this).zzvx().elapsedRealtime() >= zza2.zzdlz + Math.max(1000L, zza2.zzdlx)) {
                this.zzdly = true;
            }
            ++this.zzdlw;
            if (this.zzdlv) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzdlu.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzdlu.set("&cd", this.zzdlu.zzdlm != null ? ((string2 = ((Tracker)this.zzdlu).zzdlm.zzduk.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbp.zzu((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzdlu.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzdlw;
            this.zzdlw = Math.max(0, this.zzdlw);
            if (this.zzdlw == 0) {
                this.zzdlz = this.zzvx().elapsedRealtime();
            }
        }
    }
}

