/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzana;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaoj;
import com.google.android.gms.internal.zzaoz;
import java.util.Collections;
import java.util.List;

public final class zzamy
extends zzams {
    private final zzana zzdoz;
    private zzaoj zzdpa;
    private final zzanx zzdpb;
    private final zzaoz zzdpc;

    protected zzamy(zzamu zzamu2) {
        super(zzamu2);
        this.zzdpc = new zzaoz(zzamu2.zzvx());
        this.zzdoz = new zzana(this);
        this.zzdpb = new zzamz(this, zzamu2);
    }

    @Override
    protected final void zzuk() {
    }

    public final boolean isConnected() {
        zzj.zzuj();
        this.zzwk();
        return this.zzdpa != null;
    }

    public final boolean zzb(zzaoi zzaoi2) {
        zzbp.zzu((Object)zzaoi2);
        zzj.zzuj();
        this.zzwk();
        zzaoj zzaoj2 = this.zzdpa;
        if (zzaoj2 == null) {
            return false;
        }
        String string = zzaoi2.zzyp() ? zzanv.zzyb() : zzanv.zzyc();
        List<zzanp> list = Collections.emptyList();
        try {
            zzaoj2.zza(zzaoi2.zziy(), zzaoi2.zzyn(), string, list);
            this.zzww();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdm("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzwv() {
        zzj.zzuj();
        this.zzwk();
        zzaoj zzaoj2 = this.zzdpa;
        if (zzaoj2 == null) {
            return false;
        }
        try {
            zzaoj2.zzvr();
            this.zzww();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdm("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzww() {
        this.zzdpc.start();
        this.zzdpb.zzs(zzaod.zzdsi.get());
    }

    public final boolean connect() {
        zzj.zzuj();
        this.zzwk();
        if (this.zzdpa != null) {
            return true;
        }
        zzaoj zzaoj2 = this.zzdoz.zzwy();
        if (zzaoj2 != null) {
            this.zzdpa = zzaoj2;
            this.zzww();
            return true;
        }
        return false;
    }

    private final void zza(zzaoj zzaoj2) {
        zzj.zzuj();
        this.zzdpa = zzaoj2;
        this.zzww();
        this.zzwc().onServiceConnected();
    }

    public final void disconnect() {
        zzj.zzuj();
        this.zzwk();
        try {
            zza.zzakz();
            zzana zzana2 = this.zzdoz;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzana2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzdpa != null) {
            this.zzdpa = null;
            this.zzwc().zzvu();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzj.zzuj();
        if (this.zzdpa != null) {
            this.zzdpa = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzwc().zzvu();
        }
    }

    private final void zzwx() {
        zzj.zzuj();
        if (!this.isConnected()) {
            return;
        }
        this.zzdm("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzana zza(zzamy zzamy2) {
        return zzamy2.zzdoz;
    }

    static /* synthetic */ void zza(zzamy zzamy2, zzaoj zzaoj2) {
        zzamy2.zza(zzaoj2);
    }

    static /* synthetic */ void zza(zzamy zzamy2, ComponentName componentName) {
        zzamy2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzamy zzamy2) {
        zzamy2.zzwx();
    }
}

