/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqj;
import com.google.android.gms.internal.zzaqx;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzarb;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzdlw = new ArrayList<Runnable>();
    private boolean zzaqh;
    private Set<zza> zzdlx = new HashSet<zza>();
    private boolean zzdly;
    private boolean zzdlz;
    private volatile boolean zzdma;
    private boolean zzdmb;

    public final void initialize() {
        GoogleAnalytics googleAnalytics = this;
        zzarb zzarb2 = googleAnalytics.zzub().zzwo();
        zzarb2.zzzx();
        if (zzarb2.zzzy()) {
            googleAnalytics.setDryRun(zzarb2.zzzz());
        }
        zzarb2.zzzx();
        this.zzaqh = true;
    }

    public final boolean isInitialized() {
        return this.zzaqh;
    }

    public GoogleAnalytics(zzaor zzaor2) {
        super(zzaor2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzaor.zzbk(context).zzwx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzug() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzdlw != null) {
                Iterator<Runnable> iterator = zzdlw.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzdlw = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzdlz = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzdlz;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzdly) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(this));
            this.zzdly = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzdly) {
            this.zzj(activity);
        }
    }

    final void zzj(Activity activity) {
        Iterator<zza> iterator = this.zzdlx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzl(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzdly) {
            this.zzk(activity);
        }
    }

    final void zzk(Activity activity) {
        Iterator<zza> iterator = this.zzdlx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzm(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzub(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzaqz zzaqz2;
            Tracker tracker = new Tracker(this.zzub(), null, null);
            if (n > 0 && (zzaqz2 = (zzaqz)new zzaqx(this.zzub()).zzav(n)) != null) {
                tracker.zza(zzaqz2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzdlx.add(zza2);
        Context context = this.zzub().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzdlx.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzdma = bl;
        if (this.zzdma) {
            this.zzub().zzwm().zzwb();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzdma;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzaqj.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzaqj.setLogger(logger);
        if (!this.zzdmb) {
            String string = zzaqa.zzdta.get();
            Log.i((String)zzaqa.zzdta.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzdmb = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzub().zzwm().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzub().zzwm().zzwc();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        private /* synthetic */ GoogleAnalytics zzdmc;

        zzb(GoogleAnalytics googleAnalytics) {
            this.zzdmc = googleAnalytics;
        }

        public final void onActivityStarted(Activity activity) {
            this.zzdmc.zzj(activity);
        }

        public final void onActivityStopped(Activity activity) {
            this.zzdmc.zzk(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzl(Activity var1);

        public void zzm(Activity var1);
    }
}

