/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzaob;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaot;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaov;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzapf;
import com.google.android.gms.internal.zzapg;
import com.google.android.gms.internal.zzaph;
import com.google.android.gms.internal.zzaps;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zzapx;
import com.google.android.gms.internal.zzapy;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqm;
import com.google.android.gms.internal.zzaqr;
import com.google.android.gms.internal.zzaqs;
import com.google.android.gms.internal.zzaqw;
import com.google.android.gms.internal.zzara;
import com.google.android.gms.internal.zzarb;
import com.google.android.gms.internal.zzbgc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzapd
extends zzaop {
    private boolean mStarted;
    private final zzapa zzdro;
    private final zzaqm zzdrp;
    private final zzaql zzdrq;
    private final zzaov zzdrr;
    private long zzdrs;
    private final zzapu zzdrt;
    private final zzapu zzdru;
    private final zzaqw zzdrv;
    private long zzdrw;
    private boolean zzdrx;

    protected zzapd(zzaor zzaor2, zzaot zzaot2) {
        super(zzaor2);
        zzbq.checkNotNull((Object)zzaot2);
        this.zzdrs = Long.MIN_VALUE;
        zzaor zzaor3 = zzaor2;
        this.zzdrq = new zzaql(zzaor3);
        zzaor3 = zzaor2;
        this.zzdro = new zzapa(zzaor3);
        zzaor3 = zzaor2;
        this.zzdrp = new zzaqm(zzaor3);
        zzaor3 = zzaor2;
        this.zzdrr = new zzaov(zzaor3);
        this.zzdrv = new zzaqw(this.zzwh());
        this.zzdrt = new zzape(this, zzaor2);
        this.zzdru = new zzapf(this, zzaor2);
    }

    @Override
    protected final void zzuu() {
        this.zzdro.initialize();
        this.zzdrp.initialize();
        this.zzdrr.initialize();
    }

    final void start() {
        this.zzwu();
        zzbq.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzwk().zzc(new zzapg(this));
    }

    private final boolean zzdu(String string) {
        return zzbgc.zzcy((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzxo() {
        this.zzwu();
        zzapd zzapd2 = this;
        zzj.zzut();
        Context context = zzapd2.zzwg().getContext();
        if (!zzaqr.zzbi(context)) {
            zzapd2.zzdq("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzaqs.zzbm(context)) {
            zzapd2.zzdr("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzbi(context)) {
            zzapd2.zzdq("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzwp().zzzl();
        if (!this.zzdu("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzdr("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxy();
        }
        if (!this.zzdu("android.permission.INTERNET")) {
            this.zzdr("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxy();
        }
        if (zzaqs.zzbm(this.getContext())) {
            this.zzdn("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzdq("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzdrx && !this.zzdro.isEmpty()) {
            this.zzxr();
        }
        this.zzxu();
    }

    private final void zzxp() {
        this.zzb(new zzaph(this));
    }

    final void zzwf() {
        zzj.zzut();
        this.zzdrw = this.zzwh().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzj.zzut();
        zzapd zzapd2 = this;
        zzj.zzut();
        zzapd2.zzwu();
        if (!zzaps.zzyf()) {
            zzapd2.zzdq("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzapd2.zzdrr.isConnected()) {
            zzapd2.zzdn("Service not connected");
            return;
        }
        if (!zzapd2.zzdro.isEmpty()) {
            zzapd2.zzdn("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzaqf> list;
                try {
                    list = zzapd2.zzdro.zzn(zzaps.zzyj());
                    if (list.isEmpty()) {
                        zzapd2.zzxu();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzapd2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzapd2.zzxw();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzaqf zzaqf2 = list.get(0);
                    if (!zzapd2.zzdrr.zzb(zzaqf2)) {
                        zzapd2.zzxu();
                        return;
                    }
                    list.remove(zzaqf2);
                    try {
                        zzapd2.zzdro.zzo(zzaqf2.zzyw());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzapd2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzapd2.zzxw();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzxq() {
        try {
            this.zzdro.zzxj();
            this.zzxu();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzdru.zzr(86400000L);
    }

    protected final void zzb(zzaou zzaou2) {
        zzj.zzut();
        this.zzb("Sending first hit to property", zzaou2.zzxc());
        if (this.zzwp().zzzm().zzt(zzaps.zzyp())) {
            return;
        }
        String string = this.zzwp().zzzp();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzant zzant2 = zzara.zza(this.zzwi(), string);
        this.zzb("Found relevant installation campaign", zzant2);
        this.zza(zzaou2, zzant2);
    }

    public final void zzq(long l) {
        zzj.zzut();
        this.zzwu();
        if (l < 0L) {
            l = 0L;
        }
        this.zzdrs = l;
        this.zzxu();
    }

    private final void zzxr() {
        if (this.zzdrx) {
            return;
        }
        if (!zzaps.zzyf()) {
            return;
        }
        if (this.zzdrr.isConnected()) {
            return;
        }
        long l = zzaqa.zzdum.get();
        if (this.zzdrv.zzt(l)) {
            this.zzdrv.start();
            this.zzdn("Connecting to service");
            if (this.zzdrr.connect()) {
                this.zzdn("Connected to service");
                this.zzdrv.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzaou zzaou2, boolean bl) {
        long l;
        zzbq.checkNotNull((Object)zzaou2);
        this.zzwu();
        zzj.zzut();
        try {
            this.zzdro.beginTransaction();
            String string = zzaou2.zzvo();
            long l2 = zzaou2.zzxb();
            zzapa zzapa2 = this.zzdro;
            zzbq.zzgi((String)string);
            zzapa2.zzwu();
            zzj.zzut();
            int n = zzapa2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzapa2.zza("Deleted property records", n);
            }
            l = this.zzdro.zza(zzaou2.zzxb(), zzaou2.zzvo(), zzaou2.zzxc());
            zzaou2.zzl(l + 1L);
            zzaou zzaou3 = zzaou2;
            zzapa zzapa3 = this.zzdro;
            zzbq.checkNotNull((Object)zzaou3);
            zzapa3.zzwu();
            zzj.zzut();
            SQLiteDatabase sQLiteDatabase = zzapa3.getWritableDatabase();
            Map<String, String> map = zzaou3.zzjb();
            zzbq.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzaou3.zzxb()));
            contentValues.put("cid", zzaou3.zzvo());
            contentValues.put("tid", zzaou3.zzxc());
            contentValues.put("adid", Integer.valueOf(zzaou3.zzxd() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzaou3.zzxe()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzapa3.zzdr("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzapa3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzdro.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzdro.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzaqf zzaqf2) {
        zzaqf zzaqf3;
        zzbq.checkNotNull((Object)zzaqf2);
        zzj.zzut();
        this.zzwu();
        if (this.zzdrx) {
            this.zzdo("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzaqf2);
        }
        zzaqf zzaqf4 = zzaqf2;
        zzapd zzapd2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzaqf4.zzzb())) {
            zzaqf3 = zzaqf4;
        } else {
            Pair<String, Long> pair = zzapd2.zzwp().zzzq().zzzs();
            if (pair == null) {
                zzaqf3 = zzaqf4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzaqf4.zzjb());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzaqf zzaqf5 = zzaqf4;
                zzapd zzapd3 = zzapd2;
                zzaqf3 = new zzaqf(zzapd3, (Map<String, String>)object2, zzaqf5.zzyx(), zzaqf5.zzyz(), zzaqf5.zzyw(), zzaqf5.zzyv(), zzaqf5.zzyy());
            }
        }
        zzaqf2 = zzaqf3;
        this.zzxr();
        if (this.zzdrr.zzb(zzaqf2)) {
            this.zzdo("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzdro.zzc(zzaqf2);
            this.zzxu();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzwi().zza(zzaqf2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzwb() {
        zzj.zzut();
        this.zzwu();
        this.zzdn("Delete all hits from local store");
        try {
            zzapa zzapa2 = this.zzdro;
            zzj.zzut();
            zzapa2.zzwu();
            zzapa2.getWritableDatabase().delete("hits2", null, null);
            zzapa2 = this.zzdro;
            zzj.zzut();
            zzapa2.zzwu();
            zzapa2.getWritableDatabase().delete("properties", null, null);
            this.zzxu();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzxr();
        if (this.zzdrr.zzxf()) {
            this.zzdn("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzxs() {
        boolean bl;
        zzj.zzut();
        this.zzwu();
        this.zzdn("Dispatching a batch of local hits");
        boolean bl2 = !this.zzdrr.isConnected();
        boolean bl3 = bl = !this.zzdrp.zzzh();
        if (bl2 && bl) {
            this.zzdn("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzaps.zzyj(), zzaps.zzyk());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzaqf> list;
                block38: {
                    this.zzdro.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzdro.zzn(l);
                        if (!list.isEmpty()) break block38;
                        this.zzdn("Store is empty, nothing to dispatch");
                        this.zzxw();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzxw();
                        try {
                            this.zzdro.setTransactionSuccessful();
                            this.zzdro.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzxw();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzyw() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzxw();
                    return false;
                }
                if (this.zzdrr.isConnected()) {
                    this.zzdn("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzdrr.zzb((zzaqf)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzaqf)((Object)list2)).zzyw());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzdro.zzo(((zzaqf)((Object)list2)).zzyw());
                            arrayList.add(((zzaqf)((Object)list2)).zzyw());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzxw();
                            try {
                                this.zzdro.setTransactionSuccessful();
                                this.zzdro.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzxw();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzdrp.zzzh()) {
                    list2 = this.zzdrp.zzt(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzdro.zzr(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzxw();
                        try {
                            this.zzdro.setTransactionSuccessful();
                            this.zzdro.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzxw();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzdro.setTransactionSuccessful();
                    this.zzdro.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzxw();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzapy zzapy2) {
        long l = this.zzdrw;
        zzapy zzapy3 = zzapy2;
        zzapd zzapd2 = this;
        zzj.zzut();
        zzapd2.zzwu();
        long l2 = -1L;
        long l3 = zzapd2.zzwp().zzzn();
        if (l3 != 0L) {
            l2 = Math.abs(zzapd2.zzwh().currentTimeMillis() - l3);
        }
        zzapd2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzapd2.zzxr();
        try {
            zzapd2.zzxs();
            zzapd2.zzwp().zzzo();
            zzapd2.zzxu();
            if (zzapy3 != null) {
                zzapy3.zzd(null);
            }
            if (zzapd2.zzdrw != l) {
                zzapd2.zzdrq.zzzg();
            }
            return;
        }
        catch (Throwable throwable) {
            zzapd2.zze("Local dispatch failed", throwable);
            zzapd2.zzwp().zzzo();
            zzapd2.zzxu();
            if (zzapy3 != null) {
                zzapy3.zzd(throwable);
            }
            return;
        }
    }

    public final void zzxt() {
        zzj.zzut();
        this.zzwu();
        this.zzdo("Sync dispatching local hits");
        long l = this.zzdrw;
        this.zzxr();
        try {
            this.zzxs();
            this.zzwp().zzzo();
            this.zzxu();
            if (this.zzdrw != l) {
                this.zzdrq.zzzg();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzxu();
            return;
        }
    }

    private final long zzxk() {
        zzj.zzut();
        this.zzwu();
        try {
            return this.zzdro.zzxk();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzxu() {
        boolean bl;
        zzj.zzut();
        this.zzwu();
        zzapd zzapd2 = this;
        if (!(!zzapd2.zzdrx && zzapd2.zzxx() > 0L)) {
            this.zzdrq.unregister();
            this.zzxw();
            return;
        }
        if (this.zzdro.isEmpty()) {
            this.zzdrq.unregister();
            this.zzxw();
            return;
        }
        if (!zzaqa.zzduh.get().booleanValue()) {
            this.zzdrq.zzze();
            bl = this.zzdrq.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzapd2 = this;
            zzapd2.zzxv();
            long l3 = zzapd2.zzxx();
            long l4 = zzapd2.zzwp().zzzn();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzapd2.zzwh().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzaps.zzyh(), l3)) : Math.min(zzaps.zzyh(), l3);
            zzapd2.zza("Dispatch scheduled (ms)", l5);
            if (zzapd2.zzdrt.zzdr()) {
                l = Math.max(1L, l5 + zzapd2.zzdrt.zzyq());
                zzapd2.zzdrt.zzs(l);
                return;
            }
            zzapd2.zzdrt.zzr(l5);
            return;
        }
        this.zzxw();
        this.zzxv();
    }

    private final void zzxv() {
        long l;
        zzapx zzapx2 = this.zzwn();
        if (!zzapx2.zzyt()) {
            return;
        }
        if (!zzapx2.zzdr() && (l = this.zzxk()) != 0L && Math.abs(this.zzwh().currentTimeMillis() - l) <= zzaqa.zzdtl.get()) {
            long l2 = zzaps.zzyi();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzapx2.schedule();
        }
    }

    private final void zzxw() {
        zzapd zzapd2 = this;
        if (zzapd2.zzdrt.zzdr()) {
            zzapd2.zzdn("All hits dispatched or no network/service. Going to power save mode");
        }
        zzapd2.zzdrt.cancel();
        zzapx zzapx2 = this.zzwn();
        if (zzapx2.zzdr()) {
            zzapx2.cancel();
        }
    }

    private final long zzxx() {
        if (this.zzdrs != Long.MIN_VALUE) {
            return this.zzdrs;
        }
        long l = zzaqa.zzdtg.get();
        zzarb zzarb2 = this.zzwo();
        zzarb2.zzwu();
        if (zzarb2.zzdwm) {
            zzarb2 = this.zzwo();
            zzarb2.zzwu();
            l = (long)zzarb2.zzdut * 1000L;
        }
        return l;
    }

    public final void zzdv(String string) {
        zzbq.zzgi((String)string);
        zzj.zzut();
        zzant zzant2 = zzara.zza(this.zzwi(), string);
        if (zzant2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzwp().zzzp();
        if (string.equals(string2)) {
            this.zzdq("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzwp().zzdy(string);
        if (this.zzwp().zzzm().zzt(zzaps.zzyp())) {
            this.zzd("Campaign received too late, ignoring", zzant2);
            return;
        }
        this.zzb("Received installation campaign", zzant2);
        for (zzaou zzaou2 : this.zzdro.zzp(0L)) {
            this.zza(zzaou2, zzant2);
        }
    }

    private final void zza(zzaou zzaou2, zzant zzant2) {
        zzbq.checkNotNull((Object)zzaou2);
        zzbq.checkNotNull((Object)zzant2);
        zza zza2 = new zza(this.zzwg());
        zza2.zzcx(zzaou2.zzxc());
        zza2.enableAdvertisingIdCollection(zzaou2.zzxd());
        zzg zzg2 = ((zzi)zza2).zzuc();
        zzaob zzaob2 = zzg2.zzb(zzaob.class);
        zzaob2.zzdi("data");
        zzaob2.zzai(true);
        zzg2.zza(zzant2);
        zzanw zzanw2 = zzg2.zzb(zzanw.class);
        zzans zzans2 = zzg2.zzb(zzans.class);
        for (Map.Entry<String, String> entry : zzaou2.zzjb().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzans2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzans2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzans2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzans2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzaob2.setUserId(string2);
                continue;
            }
            zzanw2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzaou2.zzxc(), zzant2);
        zzg2.zzk(this.zzwp().zzzl());
        zzg2.zzuk();
    }

    private final void zzxy() {
        this.zzwu();
        zzj.zzut();
        this.zzdrx = true;
        this.zzdrr.disconnect();
        this.zzxu();
    }

    static /* synthetic */ void zza(zzapd zzapd2) {
        zzapd2.zzxp();
    }

    static /* synthetic */ void zzb(zzapd zzapd2) {
        zzapd2.zzxq();
    }
}

