/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaor;

class zzaql
extends BroadcastReceiver {
    private static String zzdvi = zzaql.class.getName();
    private final zzaor zzdqc;
    private boolean mRegistered;
    private boolean zzdvj;

    zzaql(zzaor zzaor2) {
        zzbq.checkNotNull((Object)zzaor2);
        this.zzdqc = zzaor2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzzf();
        String string = intent.getAction();
        this.zzdqc.zzwi().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzzh();
            if (this.zzdvj != bl) {
                this.zzdvj = bl;
                boolean bl2 = bl;
                zzaog zzaog2 = this.zzdqc.zzwm();
                zzaog2.zza("Network connectivity status changed", bl2);
                zzaog2.zzwk().zzc(new zzaoi(zzaog2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzdvi)) {
                zzaog zzaog3 = this.zzdqc.zzwm();
                zzaog3.zzdn("Radio powered up");
                zzaog3.zzwc();
            }
            return;
        }
        this.zzdqc.zzwi().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzze() {
        this.zzzf();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdqc.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzdvj = this.zzzh();
        this.zzdqc.zzwi().zza("Registering connectivity change receiver. Network connected", this.zzdvj);
        this.mRegistered = true;
    }

    private final void zzzf() {
        this.zzdqc.zzwi();
        this.zzdqc.zzwm();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdqc.zzwi().zzdn("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzdvj = false;
        Context context = this.zzdqc.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdqc.zzwi().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzzg() {
        Context context = this.zzdqc.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzdvi, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdqc.zzwi().zzdq("Connectivity unknown. Receiver not registered");
        }
        return this.zzdvj;
    }

    private final boolean zzzh() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdqc.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

