/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaow;
import com.google.android.gms.internal.zzaox;
import com.google.android.gms.internal.zzapm;
import com.google.android.gms.internal.zzaps;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzaqg;
import com.google.android.gms.internal.zzaqw;
import java.util.Collections;
import java.util.List;

public final class zzaov
extends zzaop {
    private final zzaox zzdqz;
    private zzaqg zzdra;
    private final zzapu zzdrb;
    private final zzaqw zzdrc;

    protected zzaov(zzaor zzaor2) {
        super(zzaor2);
        this.zzdrc = new zzaqw(zzaor2.zzwh());
        this.zzdqz = new zzaox(this);
        this.zzdrb = new zzaow(this, zzaor2);
    }

    @Override
    protected final void zzuu() {
    }

    public final boolean isConnected() {
        zzj.zzut();
        this.zzwu();
        return this.zzdra != null;
    }

    public final boolean zzb(zzaqf zzaqf2) {
        zzbq.checkNotNull((Object)zzaqf2);
        zzj.zzut();
        this.zzwu();
        zzaqg zzaqg2 = this.zzdra;
        if (zzaqg2 == null) {
            return false;
        }
        String string = zzaqf2.zzyz() ? zzaps.zzyl() : zzaps.zzym();
        List<zzapm> list = Collections.emptyList();
        try {
            zzaqg2.zza(zzaqf2.zzjb(), zzaqf2.zzyx(), string, list);
            this.zzxg();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdn("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzxf() {
        zzj.zzut();
        this.zzwu();
        zzaqg zzaqg2 = this.zzdra;
        if (zzaqg2 == null) {
            return false;
        }
        try {
            zzaqg2.zzwb();
            this.zzxg();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzdn("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzxg() {
        this.zzdrc.start();
        this.zzdrb.zzr(zzaqa.zzdui.get());
    }

    public final boolean connect() {
        zzj.zzut();
        this.zzwu();
        if (this.zzdra != null) {
            return true;
        }
        zzaqg zzaqg2 = this.zzdqz.zzxi();
        if (zzaqg2 != null) {
            this.zzdra = zzaqg2;
            this.zzxg();
            return true;
        }
        return false;
    }

    private final void zza(zzaqg zzaqg2) {
        zzj.zzut();
        this.zzdra = zzaqg2;
        this.zzxg();
        this.zzwm().onServiceConnected();
    }

    public final void disconnect() {
        zzj.zzut();
        this.zzwu();
        try {
            zza.zzalq();
            zzaox zzaox2 = this.zzdqz;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzaox2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzdra != null) {
            this.zzdra = null;
            this.zzwm().zzwe();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzj.zzut();
        if (this.zzdra != null) {
            this.zzdra = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzwm().zzwe();
        }
    }

    private final void zzxh() {
        zzj.zzut();
        if (!this.isConnected()) {
            return;
        }
        this.zzdn("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzaox zza(zzaov zzaov2) {
        return zzaov2.zzdqz;
    }

    static /* synthetic */ void zza(zzaov zzaov2, zzaqg zzaqg2) {
        zzaov2.zza(zzaqg2);
    }

    static /* synthetic */ void zza(zzaov zzaov2, ComponentName componentName) {
        zzaov2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzaov zzaov2) {
        zzaov2.zzxh();
    }
}

