/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzapk;
import com.google.android.gms.internal.zzapl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzapj
extends zzaop {
    private volatile String zzdox;
    private Future<String> zzdsg;

    protected zzapj(zzaor zzaor2) {
        super(zzaor2);
    }

    @Override
    protected final void zzuu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzxz() {
        this.zzwu();
        zzapj zzapj2 = this;
        synchronized (zzapj2) {
            if (this.zzdox == null) {
                this.zzdsg = this.zzwk().zza(new zzapk(this));
            }
            if (this.zzdsg != null) {
                try {
                    this.zzdox = this.zzdsg.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzdox = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzdox = "0";
                }
                if (this.zzdox == null) {
                    this.zzdox = "0";
                }
                this.zza("Loaded clientId", this.zzdox);
                this.zzdsg = null;
            }
            return this.zzdox;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzya() {
        zzapj zzapj2 = this;
        synchronized (zzapj2) {
            this.zzdox = null;
            this.zzdsg = this.zzwk().zza(new zzapl(this));
        }
        return this.zzxz();
    }

    final String zzyb() {
        String string = this.zzbl(this.zzwk().getContext());
        if (string == null) {
            string = this.zzyc();
        }
        return string;
    }

    private final String zzyc() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzs(this.zzwk().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzbl(Context context) {
        zzbq.zzgi((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzdq("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzdq("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzs(Context context, String string) {
        zzbq.zzgh((String)string);
        zzbq.zzgi((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzapj zzapj2) {
        return zzapj2.zzyc();
    }
}

