/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaps;

public final class zzapx
extends zzaop {
    private boolean zzdsu;
    private boolean zzdsv;
    private final AlarmManager zzdsw = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzdsx;

    protected zzapx(zzaor zzaor2) {
        super(zzaor2);
    }

    @Override
    protected final void zzuu() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzaps.zzyi() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzdn("Receiver registered for local dispatch.");
                this.zzdsu = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzyt() {
        return this.zzdsu;
    }

    public final boolean zzdr() {
        return this.zzdsv;
    }

    public final void schedule() {
        this.zzwu();
        zzbq.zza((boolean)this.zzdsu, (Object)"Receiver not registered");
        long l = zzaps.zzyi();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzwh().elapsedRealtime() + l;
            this.zzdsv = true;
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzdn("Scheduling upload with JobScheduler");
                long l3 = l;
                zzapx zzapx2 = this;
                ComponentName componentName = new ComponentName(zzapx2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzapx2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzapx2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzapx2.zza("Scheduling job. JobID", zzapx2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzdn("Scheduling upload with AlarmManager");
            this.zzdsw.setInexactRepeating(2, l2, l, this.zzyu());
        }
    }

    private final PendingIntent zzyu() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzdsv = false;
        this.zzdsw.cancel(this.zzyu());
        if (Build.VERSION.SDK_INT >= 24) {
            zzapx zzapx2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzapx2.getContext().getSystemService("jobscheduler");
            zzapx2.zza("Cancelling job. JobID", zzapx2.getJobId());
            jobScheduler.cancel(zzapx2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzdsx == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzdsx = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzdsx;
    }
}

