/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzass;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

final class zzaru
extends SQLiteOpenHelper {
    private /* synthetic */ zzart zza;

    zzaru(zzart zzart2, Context context, String string) {
        this.zza = zzart2;
        super(context, string, null, 1);
    }

    public final SQLiteDatabase getWritableDatabase() {
        if (!zzart.zza(this.zza).zza(3600000L)) {
            throw new SQLiteException("Database open failed");
        }
        try {
            return super.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzart.zza(this.zza).zza();
            this.zza.zzf("Opening the database failed, dropping the table and recreating it");
            String string = zzart.zzb(this.zza);
            this.zza.zzk().getDatabasePath(string).delete();
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                zzart.zza(this.zza).zzb();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException2) {
                this.zza.zze("Failed to open freshly created database", (Object)sQLiteException2);
                throw sQLiteException2;
            }
        }
    }

    private final boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            String[] stringArray = cursor.getColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    private static void zza(SQLiteDatabase sQLiteDatabase) {
        Set<String> set = zzaru.zzb(sQLiteDatabase, "properties");
        String[] stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"};
        for (int i = 0; i < 6; ++i) {
            String string = stringArray[i];
            if (set.remove(string)) continue;
            String string2 = String.valueOf(string);
            throw new SQLiteException(string2.length() != 0 ? "Database properties is missing required column: ".concat(string2) : new String("Database properties is missing required column: "));
        }
        if (!set.isEmpty()) {
            throw new SQLiteException("Database properties table has extra columns");
        }
    }

    public final void onOpen(SQLiteDatabase sQLiteDatabase) {
        if (Build.VERSION.SDK_INT < 15) {
            try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                cursor.moveToFirst();
            }
        }
        if (!this.zza(sQLiteDatabase, "hits2")) {
            sQLiteDatabase.execSQL(zzart.zzab());
        } else {
            boolean bl;
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            Set<String> set = zzaru.zzb(sQLiteDatabase2, "hits2");
            String[] stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"};
            for (int i = 0; i < 4; ++i) {
                String string = stringArray[i];
                if (set.remove(string)) continue;
                String string2 = String.valueOf(string);
                throw new SQLiteException(string2.length() != 0 ? "Database hits2 is missing required column: ".concat(string2) : new String("Database hits2 is missing required column: "));
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase2.execSQL(string);
            }
        }
        if (!this.zza(sQLiteDatabase, "properties")) {
            sQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            return;
        }
        zzaru.zza(sQLiteDatabase);
    }

    public final void onCreate(SQLiteDatabase sQLiteDatabase) {
        String string = sQLiteDatabase.getPath();
        if (zzass.zza() >= 9) {
            File file = new File(string);
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setReadable(true, true);
            file.setWritable(true, true);
        }
    }

    public final void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
    }
}

