/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzasd;
import com.google.android.gms.internal.zzase;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@Hide
public final class zzasc
extends zzari {
    private volatile String zza;
    private Future<String> zzb;

    protected zzasc(zzark zzark2) {
        super(zzark2);
    }

    @Override
    protected final void zza() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzb() {
        this.zzz();
        zzasc zzasc2 = this;
        synchronized (zzasc2) {
            if (this.zza == null) {
                this.zzb = this.zzn().zza(new zzasd(this));
            }
            if (this.zzb != null) {
                try {
                    this.zza = this.zzb.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zza = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zza = "0";
                }
                if (this.zza == null) {
                    this.zza = "0";
                }
                this.zza("Loaded clientId", (Object)this.zza);
                this.zzb = null;
            }
            return this.zza;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzc() {
        zzasc zzasc2 = this;
        synchronized (zzasc2) {
            this.zza = null;
            this.zzb = this.zzn().zza(new zzase(this));
        }
        return this.zzb();
    }

    final String zzd() {
        String string = this.zza(this.zzn().zzc());
        if (string == null) {
            string = this.zze();
        }
        return string;
    }

    private final String zze() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zza(this.zzn().zzc(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zza(Context context) {
        zzbq.zzc((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zze("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zze("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", (Object)string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zza(Context context, String string) {
        zzbq.zza((String)string);
        zzbq.zzc((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", (Object)string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzasc zzasc2) {
        return zzasc2.zze();
    }
}

