/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzatc;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatu;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzduj = new ArrayList<Runnable>();
    private boolean zzarf;
    private Set<zza> zzduk = new HashSet<zza>();
    private boolean zzdul;
    private boolean zzdum;
    private volatile boolean zzdun;
    private boolean zzduo;

    @Hide
    public final void initialize() {
        GoogleAnalytics googleAnalytics = this;
        zzatu zzatu2 = googleAnalytics.zzvr().zzye();
        zzatu2.zzabm();
        if (zzatu2.zzabn()) {
            googleAnalytics.setDryRun(zzatu2.zzabo());
        }
        zzatu2.zzabm();
        this.zzarf = true;
    }

    @Hide
    public final boolean isInitialized() {
        return this.zzarf;
    }

    @Hide
    public GoogleAnalytics(zzark zzark2) {
        super(zzark2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzark.zzbl(context).zzyn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public static void zzvw() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzduj != null) {
                Iterator<Runnable> iterator = zzduj.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzduj = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzdum = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzdum;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzdul) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(this));
            this.zzdul = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzdul) {
            this.zzk(activity);
        }
    }

    final void zzk(Activity activity) {
        Iterator<zza> iterator = this.zzduk.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzm(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzdul) {
            this.zzl(activity);
        }
    }

    final void zzl(Activity activity) {
        Iterator<zza> iterator = this.zzduk.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzn(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzvr(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzats zzats2;
            Tracker tracker = new Tracker(this.zzvr(), null, null);
            if (n > 0 && (zzats2 = (zzats)new zzatq(this.zzvr()).zzav(n)) != null) {
                tracker.zza(zzats2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzduk.add(zza2);
        Context context = this.zzvr().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzduk.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzdun = bl;
        if (this.zzdun) {
            this.zzvr().zzyc().zzxr();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzdun;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzatc.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzatc.setLogger(logger);
        if (!this.zzduo) {
            String string = zzast.zzebn.get();
            Log.i((String)zzast.zzebn.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzduo = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzvr().zzyc().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzvr().zzyc().zzxs();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        private /* synthetic */ GoogleAnalytics zzdup;

        zzb(GoogleAnalytics googleAnalytics) {
            this.zzdup = googleAnalytics;
        }

        public final void onActivityStarted(Activity activity) {
            this.zzdup.zzk(activity);
        }

        public final void onActivityStopped(Activity activity) {
            this.zzdup.zzl(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzm(Activity var1);

        public void zzn(Activity var1);
    }
}

