/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.internal.zzatc;
import com.google.android.gms.internal.zzatt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HitBuilders {
    public HitBuilders() {
    }

    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        public ItemBuilder() {
            this.set("&t", "item");
        }

        public ItemBuilder setTransactionId(String string) {
            this.set("&ti", string);
            return this;
        }

        public ItemBuilder setName(String string) {
            this.set("&in", string);
            return this;
        }

        public ItemBuilder setSku(String string) {
            this.set("&ic", string);
            return this;
        }

        public ItemBuilder setCategory(String string) {
            this.set("&iv", string);
            return this;
        }

        public ItemBuilder setPrice(double d) {
            this.set("&ip", Double.toString(d));
            return this;
        }

        public ItemBuilder setQuantity(long l) {
            this.set("&iq", Long.toString(l));
            return this;
        }

        public ItemBuilder setCurrencyCode(String string) {
            this.set("&cu", string);
            return this;
        }
    }

    @Deprecated
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        public TransactionBuilder() {
            this.set("&t", "transaction");
        }

        public TransactionBuilder setTransactionId(String string) {
            this.set("&ti", string);
            return this;
        }

        public TransactionBuilder setAffiliation(String string) {
            this.set("&ta", string);
            return this;
        }

        public TransactionBuilder setRevenue(double d) {
            this.set("&tr", Double.toString(d));
            return this;
        }

        public TransactionBuilder setTax(double d) {
            this.set("&tt", Double.toString(d));
            return this;
        }

        public TransactionBuilder setShipping(double d) {
            this.set("&ts", Double.toString(d));
            return this;
        }

        public TransactionBuilder setCurrencyCode(String string) {
            this.set("&cu", string);
            return this;
        }
    }

    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        public ExceptionBuilder() {
            this.set("&t", "exception");
        }

        public ExceptionBuilder setDescription(String string) {
            this.set("&exd", string);
            return this;
        }

        public ExceptionBuilder setFatal(boolean bl) {
            this.set("&exf", zzatt.zzao(bl));
            return this;
        }
    }

    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        public TimingBuilder() {
            this.set("&t", "timing");
        }

        public TimingBuilder(String string, String string2, long l) {
            this();
            this.setVariable(string2);
            this.setValue(l);
            this.setCategory(string);
        }

        public TimingBuilder setVariable(String string) {
            this.set("&utv", string);
            return this;
        }

        public TimingBuilder setValue(long l) {
            this.set("&utt", Long.toString(l));
            return this;
        }

        public TimingBuilder setCategory(String string) {
            this.set("&utc", string);
            return this;
        }

        public TimingBuilder setLabel(String string) {
            this.set("&utl", string);
            return this;
        }
    }

    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        public SocialBuilder() {
            this.set("&t", "social");
        }

        public SocialBuilder setNetwork(String string) {
            this.set("&sn", string);
            return this;
        }

        public SocialBuilder setAction(String string) {
            this.set("&sa", string);
            return this;
        }

        public SocialBuilder setTarget(String string) {
            this.set("&st", string);
            return this;
        }
    }

    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        public EventBuilder() {
            this.set("&t", "event");
        }

        public EventBuilder(String string, String string2) {
            this();
            this.setCategory(string);
            this.setAction(string2);
        }

        public EventBuilder setCategory(String string) {
            this.set("&ec", string);
            return this;
        }

        public EventBuilder setAction(String string) {
            this.set("&ea", string);
            return this;
        }

        public EventBuilder setLabel(String string) {
            this.set("&el", string);
            return this;
        }

        public EventBuilder setValue(long l) {
            this.set("&ev", Long.toString(l));
            return this;
        }
    }

    public static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> zzduq = new HashMap<String, String>();
        private ProductAction zzdur;
        private Map<String, List<Product>> zzdus = new HashMap<String, List<Product>>();
        private List<Promotion> zzdut = new ArrayList<Promotion>();
        private List<Product> zzduu = new ArrayList<Product>();

        protected HitBuilder() {
        }

        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        public T setNonInteraction(boolean bl) {
            this.set("&ni", zzatt.zzao(bl));
            return (T)this;
        }

        public T setCampaignParamsFromUrl(String string) {
            String string2 = zzatt.zzep(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return (T)this;
            }
            Map<String, String> map = zzatt.zzen(string2);
            this.zzh("&cc", map.get("utm_content"));
            this.zzh("&cm", map.get("utm_medium"));
            this.zzh("&cn", map.get("utm_campaign"));
            this.zzh("&cs", map.get("utm_source"));
            this.zzh("&ck", map.get("utm_term"));
            this.zzh("&ci", map.get("utm_id"));
            this.zzh("&anid", map.get("anid"));
            this.zzh("&gclid", map.get("gclid"));
            this.zzh("&dclid", map.get("dclid"));
            this.zzh("&aclid", map.get("aclid"));
            this.zzh("&gmob_t", map.get("gmob_t"));
            return (T)this;
        }

        public T setCustomDimension(int n, String string) {
            this.set(zzd.zzai(n), string);
            return (T)this;
        }

        public T setCustomMetric(int n, float f) {
            this.set(zzd.zzak(n), Float.toString(f));
            return (T)this;
        }

        public final T set(String string, String string2) {
            if (string != null) {
                this.zzduq.put(string, string2);
            } else {
                zzatc.zzcz("HitBuilder.set() called with a null paramName.");
            }
            return (T)this;
        }

        private final T zzh(String string, String string2) {
            if (string2 != null) {
                this.zzduq.put(string, string2);
            }
            return (T)this;
        }

        public final T setAll(Map<String, String> map) {
            if (map == null) {
                return (T)this;
            }
            this.zzduq.putAll(new HashMap<String, String>(map));
            return (T)this;
        }

        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.zzduq);
            if (this.zzdur != null) {
                hashMap.putAll(this.zzdur.build());
            }
            int n = 1;
            for (Promotion object : this.zzdut) {
                hashMap.putAll(object.zzdx(zzd.zzao(n)));
                ++n;
            }
            n = 1;
            for (Product product : this.zzduu) {
                hashMap.putAll(product.zzdx(zzd.zzam(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry entry : this.zzdus.entrySet()) {
                List list = (List)entry.getValue();
                String string = zzd.zzar(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzaq(n2));
                    hashMap.putAll(product.zzdx(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), (String)entry.getKey());
                }
                ++n;
            }
            return hashMap;
        }

        public T setProductAction(ProductAction productAction) {
            this.zzdur = productAction;
            return (T)this;
        }

        public T addImpression(Product product, String string) {
            if (product == null) {
                zzatc.zzcz("product should be non-null");
                return (T)this;
            }
            if (string == null) {
                string = "";
            }
            if (!this.zzdus.containsKey(string)) {
                this.zzdus.put(string, new ArrayList());
            }
            this.zzdus.get(string).add(product);
            return (T)this;
        }

        public T addPromotion(Promotion promotion) {
            if (promotion == null) {
                zzatc.zzcz("promotion should be non-null");
                return (T)this;
            }
            this.zzdut.add(promotion);
            return (T)this;
        }

        public T setPromotionAction(String string) {
            this.zzduq.put("&promoa", string);
            return (T)this;
        }

        public T addProduct(Product product) {
            if (product == null) {
                zzatc.zzcz("product should be non-null");
                return (T)this;
            }
            this.zzduu.add(product);
            return (T)this;
        }

        protected T setHitType(String string) {
            this.set("&t", string);
            return (T)this;
        }

        protected String get(String string) {
            return this.zzduq.get(string);
        }
    }
}

