/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqy;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarv;
import com.google.android.gms.internal.zzasp;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatt;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzari {
    private boolean zzdvv;
    private final Map<String, String> zzbwu = new HashMap<String, String>();
    private final Map<String, String> zzdvw = new HashMap<String, String>();
    private final zzatb zzdvx;
    private final zza zzdvy;
    private ExceptionReporter zzdvz;
    private zzats zzdwa;

    Tracker(zzark zzark2, String string, zzatb zzatb2) {
        super(zzark2);
        if (string != null) {
            this.zzbwu.put("&tid", string);
        }
        this.zzbwu.put("useSecure", "1");
        this.zzbwu.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzdvx = new zzatb("tracking", this.zzxx());
        this.zzdvy = new zza(this, zzark2);
    }

    @Override
    @Hide
    protected final void zzwk() {
        String string;
        this.zzdvy.initialize();
        String string2 = this.zzye().zzwn();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzye().zzwo()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzats zzats2) {
        String string;
        this.zzea("Loading Tracker config values");
        this.zzdwa = zzats2;
        if (this.zzdwa.zzdub != null) {
            string = this.zzdwa.zzdub;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzdwa.zzees >= 0.0) {
            string = Double.toString(this.zzdwa.zzees);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzdwa.zzeet >= 0) {
            int n = this.zzdwa.zzeet;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzdwa.zzeeu != -1) {
            boolean bl = this.zzdwa.zzeeu == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzdwa.zzeev != -1) {
            boolean bl = this.zzdwa.zzeev == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzdwa.zzeew == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzdvz != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzdvz = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzdvz);
                this.zzea("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzdvz.zzvv());
                this.zzea("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzdvy.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzdvy.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzxx().currentTimeMillis();
        if (this.zzyb().getAppOptOut()) {
            this.zzeb("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzyb().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbwu, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzatt.zzd(this.zzbwu.get("useSecure"), true);
        Tracker.zzc(this.zzdvw, hashMap);
        this.zzdvw.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzxy().zzf(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzxy().zzf(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzdvv;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbwu.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbwu.put("&a", Integer.toString(n));
            }
        }
        this.zzya().zzd(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzyk();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbwu.containsKey(string)) {
            return this.zzbwu.get(string);
        }
        if (string.equals("&ul")) {
            return zzatt.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzyg().zzzp();
        }
        if (string.equals("&sr")) {
            return this.zzyj().zzaai();
        }
        if (string.equals("&aid")) {
            return this.zzyi().zzzd().getAppId();
        }
        if (string.equals("&an")) {
            return this.zzyi().zzzd().zzwn();
        }
        if (string.equals("&av")) {
            return this.zzyi().zzzd().zzwo();
        }
        if (string.equals("&aiid")) {
            return this.zzyi().zzzd().zzwp();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbq.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbwu.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzatt.zzao(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzed("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzatt.zzao(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzdvw.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzdvw.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzdvw.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzdvw.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzdvw.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzdvw.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzdvw.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzdvw.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzdvw.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzdvw.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzdvv = bl;
    }

    static /* synthetic */ zzaqy zzb(Tracker tracker) {
        return tracker.zzyh();
    }

    static /* synthetic */ zzarv zzc(Tracker tracker) {
        return tracker.zzyi();
    }

    static /* synthetic */ zzasp zzd(Tracker tracker) {
        return tracker.zzyj();
    }

    static /* synthetic */ zzasp zze(Tracker tracker) {
        return tracker.zzyj();
    }

    static /* synthetic */ zzatb zzf(Tracker tracker) {
        return tracker.zzdvx;
    }

    static /* synthetic */ zzatd zzg(Tracker tracker) {
        return tracker.zzxy();
    }

    static /* synthetic */ zzatd zzh(Tracker tracker) {
        return tracker.zzxy();
    }

    static /* synthetic */ zzaqz zzi(Tracker tracker) {
        return tracker.zzyc();
    }

    static /* synthetic */ zzaqz zzj(Tracker tracker) {
        return tracker.zzyc();
    }

    final class zza
    extends zzari
    implements GoogleAnalytics.zza {
        private boolean zzdwj;
        private int zzdwk;
        private long zzdwl;
        private boolean zzdwm;
        private long zzdwn;
        private /* synthetic */ Tracker zzdwi;

        protected zza(Tracker tracker, zzark zzark2) {
            this.zzdwi = tracker;
            super(zzark2);
            this.zzdwl = -1L;
        }

        @Override
        protected final void zzwk() {
        }

        public final void setSessionTimeout(long l) {
            this.zzdwl = l;
            this.zzwm();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzdwj = bl;
            this.zzwm();
        }

        public final synchronized boolean zzwl() {
            boolean bl = this.zzdwm;
            this.zzdwm = false;
            return bl;
        }

        private final void zzwm() {
            if (this.zzdwl >= 0L || this.zzdwj) {
                this.zzyb().zza(this.zzdwi.zzdvy);
                return;
            }
            this.zzyb().zzb(this.zzdwi.zzdvy);
        }

        @Override
        public final void zzm(Activity activity) {
            zza zza2;
            if (this.zzdwk == 0 && (zza2 = this).zzxx().elapsedRealtime() >= zza2.zzdwn + Math.max(1000L, zza2.zzdwl)) {
                this.zzdwm = true;
            }
            ++this.zzdwk;
            if (this.zzdwj) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzdwi.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzdwi.set("&cd", this.zzdwi.zzdwa != null ? ((string2 = ((Tracker)this.zzdwi).zzdwa.zzeex.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbq.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzdwi.send(hashMap);
            }
        }

        @Override
        public final void zzn(Activity activity) {
            --this.zzdwk;
            this.zzdwk = Math.max(0, this.zzdwk);
            if (this.zzdwk == 0) {
                this.zzdwn = this.zzxx().elapsedRealtime();
            }
        }
    }
}

