/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqq;
import com.google.android.gms.internal.zzatt;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Hide
public final class zzk {
    private static volatile zzk zzdvk;
    private final Context mContext;
    private final List<zzn> zzdvl;
    private final zze zzdvm;
    private final zza zzdvn;
    private volatile zzaql zzdvo;
    private Thread.UncaughtExceptionHandler zzdvp;

    private zzk(Context context) {
        Context context2 = context.getApplicationContext();
        zzbq.checkNotNull((Object)context2);
        this.mContext = context2;
        this.zzdvn = new zza();
        this.zzdvl = new CopyOnWriteArrayList<zzn>();
        this.zzdvm = new zze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzk zzbk(Context context) {
        zzbq.checkNotNull((Object)context);
        if (zzdvk != null) return zzdvk;
        Class<zzk> clazz = zzk.class;
        synchronized (zzk.class) {
            if (zzdvk != null) return zzdvk;
            zzdvk = new zzk(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzdvk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzaql zzwh() {
        if (this.zzdvo == null) {
            zzk zzk2 = this;
            synchronized (zzk2) {
                if (this.zzdvo == null) {
                    zzaql zzaql2 = new zzaql();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzaql2.setAppId(string);
                    zzaql2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzaql2.setAppName(string2);
                    zzaql2.setAppVersion(string3);
                    this.zzdvo = zzaql2;
                }
            }
        }
        return this.zzdvo;
    }

    public final zzaqq zzwi() {
        int n;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzaqq zzaqq2 = new zzaqq();
        zzaqq2.setLanguage(zzatt.zza(Locale.getDefault()));
        zzaqq2.zzcly = n = displayMetrics.widthPixels;
        zzaqq2.zzclz = n = displayMetrics.heightPixels;
        return zzaqq2;
    }

    final void zze(zzg zzg2) {
        if (zzg2.zzwe()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzg2.zzwb()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzg zzg3 = zzg2.zzvx();
        zzg3.zzwc();
        this.zzdvn.execute(new zzl(this, zzg3));
    }

    @Hide
    public final Context getContext() {
        return this.mContext;
    }

    @Hide
    public static void zzwj() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzdvp = uncaughtExceptionHandler;
    }

    @Hide
    public final <V> Future<V> zza(Callable<V> callable) {
        zzbq.checkNotNull(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzdvn.submit(callable);
    }

    @Hide
    public final void zzd(Runnable runnable) {
        zzbq.checkNotNull((Object)runnable);
        this.zzdvn.submit(runnable);
    }

    private static void zzb(zzg zzg2) {
        zzbq.zzgw((String)"deliver should be called from worker thread");
        zzbq.checkArgument((boolean)zzg2.zzwb(), (Object)"Measurement must be submitted");
        List<zzo> list = zzg2.getTransports();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zzvu();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zzb(zzg2);
        }
    }

    static /* synthetic */ List zza(zzk zzk2) {
        return zzk2.zzdvl;
    }

    static /* synthetic */ void zza(zzk zzk2, zzg zzg2) {
        zzk.zzb(zzg2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzk zzk2) {
        return zzk2.zzdvp;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzdvt = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzdvt.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzl zzl2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzm(this, runnable, t);
        }
    }
}

