/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

@Hide
public final class zzaqy
extends zzari {
    private static boolean zzdyb;
    private AdvertisingIdClient.Info zzdyc;
    private final zzatp zzdyd;
    private String zzdye;
    private boolean zzdyf = false;
    private final Object zzdyg = new Object();

    zzaqy(zzark zzark2) {
        super(zzark2);
        this.zzdyd = new zzatp(zzark2.zzxx());
    }

    @Override
    protected final void zzwk() {
    }

    public final boolean zzxg() {
        this.zzyk();
        AdvertisingIdClient.Info info = this.zzxo();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzxn() {
        this.zzyk();
        AdvertisingIdClient.Info info = this.zzxo();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzxo() {
        if (this.zzdyd.zzu(1000L)) {
            this.zzdyd.start();
            AdvertisingIdClient.Info info = this.zzxp();
            if (this.zza(this.zzdyc, info)) {
                this.zzdyc = info;
            } else {
                this.zzee("Failed to reset client id on adid change. Not using adid");
                this.zzdyc = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzdyc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzyg().zzzp();
        Object object = this.zzdyg;
        synchronized (object) {
            String string3;
            if (!this.zzdyf) {
                this.zzdye = this.zzxq();
                this.zzdyf = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzdye)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzdz(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzdye = zzaqy.zzdy(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzaqy.zzdy(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzdye)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdye)) {
                this.zzea("Resetting the client id because Advertising Id changed.");
                string2 = this.zzyg().zzzq();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzdz(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzxp() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzed("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzdyb) break block3;
                zzdyb = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzdy(String string) {
        MessageDigest messageDigest = zzatt.zzeq("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzdz(String string) {
        try {
            String string2 = zzaqy.zzdy(string);
            this.zzea("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzdye = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzxq() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzed("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzea("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

