/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzarh;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarn;
import com.google.android.gms.internal.zzaru;
import com.google.android.gms.internal.zzasl;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatt;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzart
extends zzari
implements Closeable {
    private static final String zzdzv = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzdzw = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zzaru zzdzx;
    private final zzatp zzdzy = new zzatp(this.zzxx());
    private final zzatp zzdzz = new zzatp(this.zzxx());

    zzart(zzark zzark2) {
        super(zzark2);
        String string = "google_analytics_v4.db";
        this.zzdzx = new zzaru(this, zzark2.getContext(), string);
    }

    @Override
    protected final void zzwk() {
    }

    public final void beginTransaction() {
        this.zzyk();
        this.getWritableDatabase().beginTransaction();
    }

    public final void setTransactionSuccessful() {
        this.zzyk();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public final void endTransaction() {
        this.zzyk();
        this.getWritableDatabase().endTransaction();
    }

    public final void zzc(zzasy zzasy2) {
        zzbq.checkNotNull((Object)zzasy2);
        zzk.zzwj();
        this.zzyk();
        Object object2 = zzasy2;
        zzbq.checkNotNull((Object)object2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object3 : ((zzasy)object2).zzjq().entrySet()) {
            String l2 = object3.getKey();
            if ("ht".equals(l2) || "qt".equals(l2) || "AppUID".equals(l2)) continue;
            builder.appendQueryParameter(l2, object3.getValue());
        }
        String string = builder.build().getEncodedQuery();
        String string2 = string == null ? "" : string;
        if (string2.length() > 8192) {
            this.zzxy().zza(zzasy2, "Hit length exceeds the maximum allowed size");
            return;
        }
        object2 = this;
        int n = zzast.zzebq.get();
        long l = super.zzyu();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = super.zzn(l2);
            ((zzarh)object2).zzd("Store full, deleting hits to make room, count", list.size());
            ((zzart)object2).zzs(list);
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string2);
        contentValues.put("hit_time", Long.valueOf(zzasy2.zzaan()));
        contentValues.put("hit_app_id", Integer.valueOf(zzasy2.zzaal()));
        zzasy zzasy3 = zzasy2;
        contentValues.put("hit_url", zzasy3.zzaap() ? zzasl.zzaab() : zzasl.zzaac());
        try {
            long sQLiteException = sQLiteDatabase.insert("hits2", null, contentValues);
            if (sQLiteException == -1L) {
                this.zzee("Failed to insert a hit (got -1)");
                return;
            }
            this.zzb("Hit saved to database. db-id, hit", sQLiteException, zzasy2);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
            return;
        }
    }

    private final long zzyu() {
        zzk.zzwj();
        this.zzyk();
        return this.zzc("SELECT COUNT(*) FROM hits2", null);
    }

    @Hide
    final boolean isEmpty() {
        return this.zzyu() == 0L;
    }

    private final List<Long> zzn(long l) {
        zzk.zzwj();
        this.zzyk();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public final List<zzasy> zzo(long l) {
        zzbq.checkArgument((l >= 0L ? 1 : 0) != 0);
        zzk.zzwj();
        this.zzyk();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzasy> arrayList = new ArrayList<zzasy>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzef(string);
                    boolean bl = zzatt.zzer(string2);
                    arrayList.add(new zzasy(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzasy> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public final void zzs(List<Long> list) {
        Long l;
        zzbq.checkNotNull(list);
        zzk.zzwj();
        this.zzyk();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final void zzp(long l) {
        zzk.zzwj();
        this.zzyk();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zzs(arrayList);
    }

    public final int zzyz() {
        zzk.zzwj();
        this.zzyk();
        if (!this.zzdzy.zzu(86400000L)) {
            return 0;
        }
        this.zzdzy.start();
        this.zzea("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzxx().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public final long zzza() {
        zzk.zzwj();
        this.zzyk();
        return this.zza(zzdzw, null, 0L);
    }

    public final long zza(long l, String string, String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        this.zzyk();
        zzk.zzwj();
        return this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
    }

    public final List<zzarn> zzq(long l) {
        this.zzyk();
        zzk.zzwj();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = zzast.zzebs.get();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{"0"};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzarn> arrayList = new ArrayList<zzarn>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzeg(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzarn zzarn2 = new zzarn(0L, (String)object, string3, bl, l2, map);
                    arrayList.add(zzarn2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzed("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public final void close() {
        try {
            this.zzdzx.close();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
            return;
        }
    }

    private final long zzc(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private final long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return 0L;
        }
    }

    private final Map<String, String> zzef(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2;
            if (string.startsWith("?")) {
                string2 = string;
            } else {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            String string4 = string2;
            return zzo.zza((URI)new URI(string4), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    private final Map<String, String> zzeg(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "?".concat(string2) : new String("?");
            return zzo.zza((URI)new URI(string3), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    final SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzdzx.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private static String zzzb() {
        return "google_analytics_v4.db";
    }

    static /* synthetic */ zzatp zza(zzart zzart2) {
        return zzart2.zzdzz;
    }

    static /* synthetic */ String zzb(zzart zzart2) {
        return zzart.zzzb();
    }

    static /* synthetic */ String zzzc() {
        return zzdzv;
    }
}

