/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqm;
import com.google.android.gms.internal.zzaqp;
import com.google.android.gms.internal.zzaqu;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarm;
import com.google.android.gms.internal.zzarn;
import com.google.android.gms.internal.zzaro;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzarx;
import com.google.android.gms.internal.zzary;
import com.google.android.gms.internal.zzarz;
import com.google.android.gms.internal.zzasa;
import com.google.android.gms.internal.zzasl;
import com.google.android.gms.internal.zzasn;
import com.google.android.gms.internal.zzasq;
import com.google.android.gms.internal.zzasr;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzate;
import com.google.android.gms.internal.zzatf;
import com.google.android.gms.internal.zzatk;
import com.google.android.gms.internal.zzatl;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatt;
import com.google.android.gms.internal.zzatu;
import com.google.android.gms.internal.zzbih;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Hide
final class zzarw
extends zzari {
    private boolean mStarted;
    private final zzart zzeab;
    private final zzatf zzeac;
    private final zzate zzead;
    private final zzaro zzeae;
    private long zzeaf;
    private final zzasn zzeag;
    private final zzasn zzeah;
    private final zzatp zzeai;
    private long zzeaj;
    private boolean zzeak;

    protected zzarw(zzark zzark2, zzarm zzarm2) {
        super(zzark2);
        zzbq.checkNotNull((Object)zzarm2);
        this.zzeaf = Long.MIN_VALUE;
        zzark zzark3 = zzark2;
        this.zzead = new zzate(zzark3);
        zzark3 = zzark2;
        this.zzeab = new zzart(zzark3);
        zzark3 = zzark2;
        this.zzeac = new zzatf(zzark3);
        zzark3 = zzark2;
        this.zzeae = new zzaro(zzark3);
        this.zzeai = new zzatp(this.zzxx());
        this.zzeag = new zzarx(this, zzark2);
        this.zzeah = new zzary(this, zzark2);
    }

    @Override
    protected final void zzwk() {
        this.zzeab.initialize();
        this.zzeac.initialize();
        this.zzeae.initialize();
    }

    final void start() {
        this.zzyk();
        zzbq.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzya().zzd(new zzarz(this));
    }

    private final boolean zzeh(String string) {
        return zzbih.zzdd((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzze() {
        this.zzyk();
        zzarw zzarw2 = this;
        zzk.zzwj();
        Context context = zzarw2.zzxw().getContext();
        if (!zzatk.zzbj(context)) {
            zzarw2.zzed("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzatl.zzbn(context)) {
            zzarw2.zzee("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzbj(context)) {
            zzarw2.zzed("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzyf().zzaba();
        if (!this.zzeh("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzee("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzzo();
        }
        if (!this.zzeh("android.permission.INTERNET")) {
            this.zzee("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzzo();
        }
        if (zzatl.zzbn(this.getContext())) {
            this.zzea("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzed("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzeak && !this.zzeab.isEmpty()) {
            this.zzzh();
        }
        this.zzzk();
    }

    private final void zzzf() {
        this.zzb(new zzasa(this));
    }

    final void zzxv() {
        zzk.zzwj();
        this.zzeaj = this.zzxx().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzk.zzwj();
        zzarw zzarw2 = this;
        zzk.zzwj();
        zzarw2.zzyk();
        if (!zzasl.zzzv()) {
            zzarw2.zzed("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzarw2.zzeae.isConnected()) {
            zzarw2.zzea("Service not connected");
            return;
        }
        if (!zzarw2.zzeab.isEmpty()) {
            zzarw2.zzea("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzasy> list;
                try {
                    list = zzarw2.zzeab.zzo(zzasl.zzzz());
                    if (list.isEmpty()) {
                        zzarw2.zzzk();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzarw2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzarw2.zzzm();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzasy zzasy2 = list.get(0);
                    if (!zzarw2.zzeae.zzb(zzasy2)) {
                        zzarw2.zzzk();
                        return;
                    }
                    list.remove(zzasy2);
                    try {
                        zzarw2.zzeab.zzp(zzasy2.zzaam());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzarw2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzarw2.zzzm();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzzg() {
        try {
            this.zzeab.zzyz();
            this.zzzk();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzeah.zzs(86400000L);
    }

    protected final void zzb(zzarn zzarn2) {
        zzk.zzwj();
        this.zzb("Sending first hit to property", zzarn2.zzys());
        if (this.zzyf().zzabb().zzu(zzasl.zzaaf())) {
            return;
        }
        String string = this.zzyf().zzabe();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzaqm zzaqm2 = zzatt.zza(this.zzxy(), string);
        this.zzb("Found relevant installation campaign", zzaqm2);
        this.zza(zzarn2, zzaqm2);
    }

    public final void zzr(long l) {
        zzk.zzwj();
        this.zzyk();
        if (l < 0L) {
            l = 0L;
        }
        this.zzeaf = l;
        this.zzzk();
    }

    private final void zzzh() {
        if (this.zzeak) {
            return;
        }
        if (!zzasl.zzzv()) {
            return;
        }
        if (this.zzeae.isConnected()) {
            return;
        }
        long l = zzast.zzecz.get();
        if (this.zzeai.zzu(l)) {
            this.zzeai.start();
            this.zzea("Connecting to service");
            if (this.zzeae.connect()) {
                this.zzea("Connected to service");
                this.zzeai.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzarn zzarn2, boolean bl) {
        long l;
        zzbq.checkNotNull((Object)zzarn2);
        this.zzyk();
        zzk.zzwj();
        try {
            this.zzeab.beginTransaction();
            String string = zzarn2.zzxe();
            long l2 = zzarn2.zzyr();
            zzart zzart2 = this.zzeab;
            zzbq.zzgv((String)string);
            zzart2.zzyk();
            zzk.zzwj();
            int n = zzart2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzart2.zza("Deleted property records", n);
            }
            l = this.zzeab.zza(zzarn2.zzyr(), zzarn2.zzxe(), zzarn2.zzys());
            zzarn2.zzm(l + 1L);
            zzarn zzarn3 = zzarn2;
            zzart zzart3 = this.zzeab;
            zzbq.checkNotNull((Object)zzarn3);
            zzart3.zzyk();
            zzk.zzwj();
            SQLiteDatabase sQLiteDatabase = zzart3.getWritableDatabase();
            Map<String, String> map = zzarn3.zzjq();
            zzbq.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzarn3.zzyr()));
            contentValues.put("cid", zzarn3.zzxe());
            contentValues.put("tid", zzarn3.zzys());
            contentValues.put("adid", Integer.valueOf(zzarn3.zzyt() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzarn3.zzyu()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzart3.zzee("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzart3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzeab.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzeab.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzasy zzasy2) {
        zzasy zzasy3;
        zzbq.checkNotNull((Object)zzasy2);
        zzk.zzwj();
        this.zzyk();
        if (this.zzeak) {
            this.zzeb("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzasy2);
        }
        zzasy zzasy4 = zzasy2;
        zzarw zzarw2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzasy4.zzaar())) {
            zzasy3 = zzasy4;
        } else {
            Pair<String, Long> pair = zzarw2.zzyf().zzabf().zzabh();
            if (pair == null) {
                zzasy3 = zzasy4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzasy4.zzjq());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzasy zzasy5 = zzasy4;
                zzarw zzarw3 = zzarw2;
                zzasy3 = new zzasy(zzarw3, (Map<String, String>)object2, zzasy5.zzaan(), zzasy5.zzaap(), zzasy5.zzaam(), zzasy5.zzaal(), zzasy5.zzaao());
            }
        }
        zzasy2 = zzasy3;
        this.zzzh();
        if (this.zzeae.zzb(zzasy2)) {
            this.zzeb("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzeab.zzc(zzasy2);
            this.zzzk();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzxy().zza(zzasy2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzxr() {
        zzk.zzwj();
        this.zzyk();
        this.zzea("Delete all hits from local store");
        try {
            zzart zzart2 = this.zzeab;
            zzk.zzwj();
            zzart2.zzyk();
            zzart2.getWritableDatabase().delete("hits2", null, null);
            zzart2 = this.zzeab;
            zzk.zzwj();
            zzart2.zzyk();
            zzart2.getWritableDatabase().delete("properties", null, null);
            this.zzzk();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzzh();
        if (this.zzeae.zzyv()) {
            this.zzea("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzzi() {
        boolean bl;
        zzk.zzwj();
        this.zzyk();
        this.zzea("Dispatching a batch of local hits");
        boolean bl2 = !this.zzeae.isConnected();
        boolean bl3 = bl = !this.zzeac.zzaax();
        if (bl2 && bl) {
            this.zzea("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzasl.zzzz(), zzasl.zzaaa());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzasy> list;
                block38: {
                    this.zzeab.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzeab.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzea("Store is empty, nothing to dispatch");
                        this.zzzm();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzzm();
                        try {
                            this.zzeab.setTransactionSuccessful();
                            this.zzeab.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzzm();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzaam() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzzm();
                    return false;
                }
                if (this.zzeae.isConnected()) {
                    this.zzea("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzeae.zzb((zzasy)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzasy)((Object)list2)).zzaam());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzeab.zzp(((zzasy)((Object)list2)).zzaam());
                            arrayList.add(((zzasy)((Object)list2)).zzaam());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzzm();
                            try {
                                this.zzeab.setTransactionSuccessful();
                                this.zzeab.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzzm();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzeac.zzaax()) {
                    list2 = this.zzeac.zzu(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzeab.zzs(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzzm();
                        try {
                            this.zzeab.setTransactionSuccessful();
                            this.zzeab.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzzm();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzeab.setTransactionSuccessful();
                    this.zzeab.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzzm();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzasr zzasr2) {
        long l = this.zzeaj;
        zzasr zzasr3 = zzasr2;
        zzarw zzarw2 = this;
        zzk.zzwj();
        zzarw2.zzyk();
        long l2 = -1L;
        long l3 = zzarw2.zzyf().zzabc();
        if (l3 != 0L) {
            l2 = Math.abs(zzarw2.zzxx().currentTimeMillis() - l3);
        }
        zzarw2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzarw2.zzzh();
        try {
            zzarw2.zzzi();
            zzarw2.zzyf().zzabd();
            zzarw2.zzzk();
            if (zzasr3 != null) {
                zzasr3.zze(null);
            }
            if (zzarw2.zzeaj != l) {
                zzarw2.zzead.zzaaw();
            }
            return;
        }
        catch (Throwable throwable) {
            zzarw2.zze("Local dispatch failed", throwable);
            zzarw2.zzyf().zzabd();
            zzarw2.zzzk();
            if (zzasr3 != null) {
                zzasr3.zze(throwable);
            }
            return;
        }
    }

    public final void zzzj() {
        zzk.zzwj();
        this.zzyk();
        this.zzeb("Sync dispatching local hits");
        long l = this.zzeaj;
        this.zzzh();
        try {
            this.zzzi();
            this.zzyf().zzabd();
            this.zzzk();
            if (this.zzeaj != l) {
                this.zzead.zzaaw();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzzk();
            return;
        }
    }

    private final long zzza() {
        zzk.zzwj();
        this.zzyk();
        try {
            return this.zzeab.zzza();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzzk() {
        boolean bl;
        zzk.zzwj();
        this.zzyk();
        zzarw zzarw2 = this;
        if (!(!zzarw2.zzeak && zzarw2.zzzn() > 0L)) {
            this.zzead.unregister();
            this.zzzm();
            return;
        }
        if (this.zzeab.isEmpty()) {
            this.zzead.unregister();
            this.zzzm();
            return;
        }
        if (!zzast.zzecu.get().booleanValue()) {
            this.zzead.zzaau();
            bl = this.zzead.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzarw2 = this;
            zzarw2.zzzl();
            long l3 = zzarw2.zzzn();
            long l4 = zzarw2.zzyf().zzabc();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzarw2.zzxx().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzasl.zzzx(), l3)) : Math.min(zzasl.zzzx(), l3);
            zzarw2.zza("Dispatch scheduled (ms)", l5);
            if (zzarw2.zzeag.zzea()) {
                l = Math.max(1L, l5 + zzarw2.zzeag.zzaag());
                zzarw2.zzeag.zzt(l);
                return;
            }
            zzarw2.zzeag.zzs(l5);
            return;
        }
        this.zzzm();
        this.zzzl();
    }

    private final void zzzl() {
        long l;
        zzasq zzasq2 = this.zzyd();
        if (!zzasq2.zzaaj()) {
            return;
        }
        if (!zzasq2.zzea() && (l = this.zzza()) != 0L && Math.abs(this.zzxx().currentTimeMillis() - l) <= zzast.zzeby.get()) {
            long l2 = zzasl.zzzy();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzasq2.schedule();
        }
    }

    private final void zzzm() {
        zzarw zzarw2 = this;
        if (zzarw2.zzeag.zzea()) {
            zzarw2.zzea("All hits dispatched or no network/service. Going to power save mode");
        }
        zzarw2.zzeag.cancel();
        zzasq zzasq2 = this.zzyd();
        if (zzasq2.zzea()) {
            zzasq2.cancel();
        }
    }

    private final long zzzn() {
        if (this.zzeaf != Long.MIN_VALUE) {
            return this.zzeaf;
        }
        long l = zzast.zzebt.get();
        zzatu zzatu2 = this.zzye();
        zzatu2.zzyk();
        if (zzatu2.zzeez) {
            zzatu2 = this.zzye();
            zzatu2.zzyk();
            l = (long)zzatu2.zzedg * 1000L;
        }
        return l;
    }

    public final void zzei(String string) {
        zzbq.zzgv((String)string);
        zzk.zzwj();
        zzaqm zzaqm2 = zzatt.zza(this.zzxy(), string);
        if (zzaqm2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzyf().zzabe();
        if (string.equals(string2)) {
            this.zzed("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzyf().zzel(string);
        if (this.zzyf().zzabb().zzu(zzasl.zzaaf())) {
            this.zzd("Campaign received too late, ignoring", zzaqm2);
            return;
        }
        this.zzb("Received installation campaign", zzaqm2);
        for (zzarn zzarn2 : this.zzeab.zzq(0L)) {
            this.zza(zzarn2, zzaqm2);
        }
    }

    private final void zza(zzarn zzarn2, zzaqm zzaqm2) {
        zzbq.checkNotNull((Object)zzarn2);
        zzbq.checkNotNull((Object)zzaqm2);
        zza zza2 = new zza(this.zzxw());
        zza2.zzdk(zzarn2.zzys());
        zza2.enableAdvertisingIdCollection(zzarn2.zzyt());
        zzg zzg2 = ((zzj)zza2).zzvs();
        zzaqu zzaqu2 = zzg2.zzb(zzaqu.class);
        zzaqu2.zzdv("data");
        zzaqu2.zzan(true);
        zzg2.zza(zzaqm2);
        zzaqp zzaqp2 = zzg2.zzb(zzaqp.class);
        zzaql zzaql2 = zzg2.zzb(zzaql.class);
        for (Map.Entry<String, String> entry : zzarn2.zzjq().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzaql2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzaql2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzaql2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzaql2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzaqu2.setUserId(string2);
                continue;
            }
            zzaqp2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzarn2.zzys(), zzaqm2);
        zzg2.zzl(this.zzyf().zzaba());
        zzg2.zzwa();
    }

    private final void zzzo() {
        this.zzyk();
        zzk.zzwj();
        this.zzeak = true;
        this.zzeae.disconnect();
        this.zzzk();
    }

    static /* synthetic */ void zza(zzarw zzarw2) {
        zzarw2.zzzf();
    }

    static /* synthetic */ void zzb(zzarw zzarw2) {
        zzarw2.zzzg();
    }
}

