/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzasd;
import com.google.android.gms.internal.zzase;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@Hide
public final class zzasc
extends zzari {
    private volatile String zzdxk;
    private Future<String> zzeat;

    protected zzasc(zzark zzark2) {
        super(zzark2);
    }

    @Override
    protected final void zzwk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzzp() {
        this.zzyk();
        zzasc zzasc2 = this;
        synchronized (zzasc2) {
            if (this.zzdxk == null) {
                this.zzeat = this.zzya().zza(new zzasd(this));
            }
            if (this.zzeat != null) {
                try {
                    this.zzdxk = this.zzeat.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzdxk = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzdxk = "0";
                }
                if (this.zzdxk == null) {
                    this.zzdxk = "0";
                }
                this.zza("Loaded clientId", this.zzdxk);
                this.zzeat = null;
            }
            return this.zzdxk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzzq() {
        zzasc zzasc2 = this;
        synchronized (zzasc2) {
            this.zzdxk = null;
            this.zzeat = this.zzya().zza(new zzase(this));
        }
        return this.zzzp();
    }

    final String zzzr() {
        String string = this.zzbm(this.zzya().getContext());
        if (string == null) {
            string = this.zzzs();
        }
        return string;
    }

    private final String zzzs() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzo(this.zzya().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzbm(Context context) {
        zzbq.zzgw((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzed("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzed("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzo(Context context, String string) {
        zzbq.zzgv((String)string);
        zzbq.zzgw((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzasc zzasc2) {
        return zzasc2.zzzs();
    }
}

