/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzarb;
import com.google.android.gms.internal.zzark;

class zzate
extends BroadcastReceiver {
    private static String zzedv = zzate.class.getName();
    private final zzark zzdyp;
    private boolean mRegistered;
    private boolean zzedw;

    zzate(zzark zzark2) {
        zzbq.checkNotNull((Object)zzark2);
        this.zzdyp = zzark2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzaav();
        String string = intent.getAction();
        this.zzdyp.zzxy().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzaax();
            if (this.zzedw != bl) {
                this.zzedw = bl;
                boolean bl2 = bl;
                zzaqz zzaqz2 = this.zzdyp.zzyc();
                zzaqz2.zza("Network connectivity status changed", bl2);
                zzaqz2.zzya().zzd(new zzarb(zzaqz2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzedv)) {
                zzaqz zzaqz3 = this.zzdyp.zzyc();
                zzaqz3.zzea("Radio powered up");
                zzaqz3.zzxs();
            }
            return;
        }
        this.zzdyp.zzxy().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzaau() {
        this.zzaav();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdyp.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzedw = this.zzaax();
        this.zzdyp.zzxy().zza("Registering connectivity change receiver. Network connected", this.zzedw);
        this.mRegistered = true;
    }

    private final void zzaav() {
        this.zzdyp.zzxy();
        this.zzdyp.zzyc();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdyp.zzxy().zzea("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzedw = false;
        Context context = this.zzdyp.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdyp.zzxy().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzaaw() {
        Context context = this.zzdyp.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzedv, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdyp.zzxy().zzed("Connectivity unknown. Receiver not registered");
        }
        return this.zzedw;
    }

    private final boolean zzaax() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdyp.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

