/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcl;
import java.util.ArrayList;

@VisibleForTesting
public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzqq;
    private final Tracker zzqr;
    private final Context zzqs;
    private ExceptionParser zzqt;
    private GoogleAnalytics zzqu;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzqq = uncaughtExceptionHandler;
        this.zzqr = tracker;
        this.zzqt = new StandardExceptionParser(context, new ArrayList<String>());
        this.zzqs = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzcl.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzqt;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzqt = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzqt != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzqt.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzcl.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzqr.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zzqu == null) {
            exceptionReporter.zzqu = GoogleAnalytics.getInstance(exceptionReporter.zzqs);
        }
        object = exceptionReporter.zzqu;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zzh().zzby().zzbp();
        if (this.zzqq != null) {
            zzcl.v("Passing exception to the original handler");
            this.zzqq.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zzl() {
        return this.zzqq;
    }
}

