/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzde;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzqv = new ArrayList<Runnable>();
    private boolean zzqw;
    private Set<zza> zzqx = new HashSet<zza>();
    private boolean zzqy;
    private boolean zzqz;
    private volatile boolean zzra;
    private boolean zzrb;

    public final void zzm() {
        GoogleAnalytics googleAnalytics = this;
        zzde zzde2 = googleAnalytics.zzh().zzca();
        zzde2.zzfm();
        if (zzde2.zzfn()) {
            googleAnalytics.setDryRun(zzde2.zzfo());
        }
        zzde2.zzfm();
        this.zzqw = true;
    }

    public final boolean isInitialized() {
        return this.zzqw;
    }

    @VisibleForTesting
    public GoogleAnalytics(zzat zzat2) {
        super(zzat2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzat.zzc(context).zzck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzn() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzqv != null) {
                Iterator<Runnable> iterator = zzqv.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzqv = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzqz = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzqz;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzqy) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzqy = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzqy) {
            this.zza(activity);
        }
    }

    @VisibleForTesting
    final void zza(Activity activity) {
        Iterator<zza> iterator = this.zzqx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzc(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzqy) {
            this.zzb(activity);
        }
    }

    @VisibleForTesting
    final void zzb(Activity activity) {
        Iterator<zza> iterator = this.zzqx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzh(), string, null);
            tracker.zzm();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzdc zzdc2;
            Tracker tracker = new Tracker(this.zzh(), null, null);
            if (n > 0 && (zzdc2 = (zzdc)new zzda(this.zzh()).zzo(n)) != null) {
                tracker.zza(zzdc2);
            }
            tracker.zzm();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzqx.add(zza2);
        Context context = this.zzh().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzqx.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzra = bl;
        if (this.zzra) {
            this.zzh().zzby().zzbn();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzra;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzcl.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzcl.setLogger(logger);
        if (!this.zzrb) {
            String string = zzcc.zzyh.get();
            Log.i((String)zzcc.zzyh.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzrb = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzh().zzby().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzh().zzby().zzbo();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public final void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zza(activity);
        }

        public final void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzb(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzc(Activity var1);

        public void zzd(Activity var1);
    }
}

