/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzbt;
import java.io.IOException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

class zzbs<T extends zzbr>
extends zzaq {
    private zzbt<T> zzxt;

    public zzbs(zzat zzat2, zzbt<T> zzbt2) {
        super(zzat2);
        this.zzxt = zzbt2;
    }

    public final T zzo(int n) {
        try {
            return this.zza(this.zzbs().zzci().getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzd("inflate() called with unknown resourceId", (Object)notFoundException);
            return null;
        }
    }

    private final T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string;
                    String string2;
                    String string3 = xmlResourceParser.getName().toLowerCase(Locale.US);
                    if (string3.equals("screenname")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            this.zzxt.zzb(string2, string);
                        }
                    } else if (string3.equals("string")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && string != null) {
                            this.zzxt.zzc(string2, string);
                        }
                    } else if (string3.equals("bool")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string);
                                this.zzxt.zza(string2, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing bool configuration value", string, numberFormatException);
                            }
                        }
                    } else if (string3.equals("integer")) {
                        string2 = xmlResourceParser.getAttributeValue(null, "name");
                        string = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                int n2 = Integer.parseInt(string);
                                this.zzxt.zzb(string2, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing int configuration value", string, numberFormatException);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            this.zze("Error parsing tracker configuration file", throwable);
        }
        return this.zzxt.zzdr();
    }
}

