/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbu;

public final class zzbz
extends zzar {
    private boolean zzyb;
    private boolean zzyc;
    private final AlarmManager zzyd = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzye;

    protected zzbz(zzat zzat2) {
        super(zzat2);
    }

    @Override
    protected final void zzac() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzbu.zzdw() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzq("Receiver registered for local dispatch.");
                this.zzyb = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzei() {
        return this.zzyb;
    }

    public final boolean zzef() {
        return this.zzyc;
    }

    public final void zzej() {
        this.zzch();
        Preconditions.checkState((boolean)this.zzyb, (Object)"Receiver not registered");
        long l = zzbu.zzdw();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzbt().elapsedRealtime() + l;
            this.zzyc = true;
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzq("Scheduling upload with JobScheduler");
                long l3 = l;
                zzbz zzbz2 = this;
                ComponentName componentName = new ComponentName(zzbz2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzbz2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzbz2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzbz2.zza("Scheduling job. JobID", zzbz2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzq("Scheduling upload with AlarmManager");
            this.zzyd.setInexactRepeating(2, l2, l, this.zzek());
        }
    }

    private final PendingIntent zzek() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzyc = false;
        this.zzyd.cancel(this.zzek());
        if (Build.VERSION.SDK_INT >= 24) {
            zzbz zzbz2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzbz2.getContext().getSystemService("jobscheduler");
            zzbz2.zza("Cancelling job. JobID", zzbz2.getJobId());
            jobScheduler.cancel(zzbz2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzye == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzye = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzye;
    }
}

