/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.internal.measurement.zzz;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzaq
implements zzo {
    private static DecimalFormat zzqq;
    private final zzat zzqm;
    private final String zzqr;
    private final Uri zzqs;

    public zzb(zzat zzat2, String string) {
        this(zzat2, string, true, false);
    }

    private zzb(zzat zzat2, String string, boolean bl, boolean bl2) {
        super(zzat2);
        Preconditions.checkNotEmpty((String)string);
        this.zzqm = zzat2;
        this.zzqr = string;
        this.zzqs = zzb.zzb(this.zzqr);
    }

    static Uri zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzk() {
        return this.zzqs;
    }

    @Override
    public final void zzb(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        Preconditions.checkArgument((boolean)zzg2.zzt(), (Object)"Can't deliver not submitted measurement");
        Preconditions.checkNotMainThread((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzo();
        zzad zzad2 = zzg3.zzb(zzad.class);
        if (TextUtils.isEmpty((CharSequence)zzad2.zzay())) {
            this.zzbu().zza(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzad2.zzaz())) {
            this.zzbu().zza(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzqm.zzck().getAppOptOut()) {
            return;
        }
        double d = zzad2.zzbf();
        if (zzdd.zza(d, zzad2.zzaz())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzas.zzvp);
        map.put("tid", this.zzqr);
        if (this.zzqm.zzck().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzdd.zzb(hashMap, "uid", zzad2.zzba());
        zzu zzu2 = zzg2.zza(zzu.class);
        if (zzu2 != null) {
            zzdd.zzb(hashMap, "an", zzu2.zzaf());
            zzdd.zzb(hashMap, "aid", zzu2.zzah());
            zzdd.zzb(hashMap, "av", zzu2.zzag());
            zzdd.zzb(hashMap, "aiid", zzu2.zzai());
        }
        zzaw zzaw2 = new zzaw(0L, zzad2.zzaz(), this.zzqr, !TextUtils.isEmpty((CharSequence)zzad2.zzbb()), 0L, hashMap);
        long l = this.zzby().zza(zzaw2);
        map.put("_s", String.valueOf(l));
        zzch zzch2 = new zzch(this.zzbu(), map, zzg2.zzr(), true);
        this.zzby().zza(zzch2);
    }

    @VisibleForTesting
    private static Map<String, String> zzc(zzg zzg2) {
        zzu zzu2;
        zzx zzx2;
        Object object;
        Object object2;
        Object object3;
        zzw zzw2;
        zzag zzag2;
        zzaf zzaf2;
        zzac zzac2;
        zzv zzv2;
        zzab zzab2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzy zzy2 = zzg2.zza(zzy.class);
        if (zzy2 != null) {
            object5 = zzy2.zzas().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zza((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzab2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzab2));
            }
        }
        if ((object5 = zzg2.zza(zzad.class)) != null) {
            zzb.zza(hashMap, "t", ((zzad)object5).zzay());
            zzb.zza(hashMap, "cid", ((zzad)object5).zzaz());
            zzb.zza(hashMap, "uid", ((zzad)object5).zzba());
            zzb.zza(hashMap, "sc", ((zzad)object5).zzbd());
            zzb.zza(hashMap, "sf", ((zzad)object5).zzbf());
            zzb.zza(hashMap, "ni", ((zzad)object5).zzbe());
            zzb.zza(hashMap, "adid", ((zzad)object5).zzbb());
            zzb.zza(hashMap, "ate", ((zzad)object5).zzbc());
        }
        if ((object4 = zzg2.zza(zzae.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzae)object4).zzbg());
            zzb.zza(hashMap, "a", ((zzae)object4).zzbh());
            zzb.zza(hashMap, "dr", ((zzae)object4).zzbi());
        }
        if ((zzab2 = zzg2.zza(zzab.class)) != null) {
            zzb.zza(hashMap, "ec", zzab2.zzax());
            zzb.zza(hashMap, "ea", zzab2.getAction());
            zzb.zza(hashMap, "el", zzab2.getLabel());
            zzb.zza(hashMap, "ev", zzab2.getValue());
        }
        if ((zzv2 = zzg2.zza(zzv.class)) != null) {
            zzb.zza(hashMap, "cn", zzv2.getName());
            zzb.zza(hashMap, "cs", zzv2.getSource());
            zzb.zza(hashMap, "cm", zzv2.zzaj());
            zzb.zza(hashMap, "ck", zzv2.zzak());
            zzb.zza(hashMap, "cc", zzv2.zzal());
            zzb.zza(hashMap, "ci", zzv2.getId());
            zzb.zza(hashMap, "anid", zzv2.zzam());
            zzb.zza(hashMap, "gclid", zzv2.zzan());
            zzb.zza(hashMap, "dclid", zzv2.zzao());
            zzb.zza(hashMap, "aclid", zzv2.zzap());
        }
        if ((zzac2 = zzg2.zza(zzac.class)) != null) {
            zzb.zza(hashMap, "exd", zzac2.zzub);
            zzb.zza(hashMap, "exf", zzac2.zzuc);
        }
        if ((zzaf2 = zzg2.zza(zzaf.class)) != null) {
            zzb.zza(hashMap, "sn", zzaf2.zzus);
            zzb.zza(hashMap, "sa", zzaf2.zzut);
            zzb.zza(hashMap, "st", zzaf2.zzuu);
        }
        if ((zzag2 = zzg2.zza(zzag.class)) != null) {
            zzb.zza(hashMap, "utv", zzag2.zzuv);
            zzb.zza(hashMap, "utt", zzag2.zzuw);
            zzb.zza(hashMap, "utc", zzag2.mCategory);
            zzb.zza(hashMap, "utl", zzag2.zzux);
        }
        if ((zzw2 = zzg2.zza(zzw.class)) != null) {
            object3 = zzw2.zzaq().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zzc(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzx2 = zzg2.zza(zzx.class)) != null) {
            object2 = zzx2.zzar().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zze((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zza((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzaa.class)) != null) {
            object2 = ((zzaa)object3).zzat();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzaa)object3).zzaw()) {
                hashMap.putAll(promotion.zzn(zzd.zzi(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzaa)object3).zzau()) {
                hashMap.putAll(product.zzn(zzd.zzg(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzaa)object3).zzav().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzl(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzj(n2));
                    hashMap.putAll(product.zzn(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzz.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzz)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzz)object2).zztv);
            zzb.zza(hashMap, "sr", ((zzz)object2).zztw, ((zzz)object2).zztx);
            zzb.zza(hashMap, "vp", ((zzz)object2).zzty, ((zzz)object2).zztz);
        }
        if ((zzu2 = zzg2.zza(zzu.class)) != null) {
            zzb.zza(hashMap, "an", zzu2.zzaf());
            zzb.zza(hashMap, "aid", zzu2.zzah());
            zzb.zza(hashMap, "aiid", zzu2.zzai());
            zzb.zza(hashMap, "av", zzu2.zzag());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    private static String zza(double d) {
        if (zzqq == null) {
            zzqq = new DecimalFormat("0.######");
        }
        return zzqq.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zza(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

