/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcu;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzai
extends zzar {
    private final zzbf zzvf;

    public zzai(zzat zzat2, zzav zzav2) {
        super(zzat2);
        Preconditions.checkNotNull((Object)zzav2);
        zzat zzat3 = zzat2;
        zzav zzav3 = zzav2;
        this.zzvf = new zzbf(zzat3, zzav3);
    }

    @Override
    protected final void zzac() {
        this.zzvf.zzm();
    }

    public final void start() {
        this.zzvf.start();
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzch();
        this.zzb("setLocalDispatchPeriod (sec)", n);
        this.zzbw().zza(new zzaj(this, n));
    }

    public final long zza(zzaw zzaw2) {
        this.zzch();
        Preconditions.checkNotNull((Object)zzaw2);
        zzk.zzab();
        long l = this.zzvf.zza(zzaw2, true);
        if (l == 0L) {
            this.zzvf.zzb(zzaw2);
        }
        return l;
    }

    public final void zza(zzch zzch2) {
        Preconditions.checkNotNull((Object)zzch2);
        this.zzch();
        this.zzb("Hit delivery requested", zzch2);
        this.zzbw().zza(new zzam(this, zzch2));
    }

    public final void zzbn() {
        this.zzch();
        this.zzbw().zza(new zzan(this));
    }

    public final void zza(zzca zzca2) {
        this.zzch();
        this.zzbw().zza(new zzao(this, zzca2));
    }

    public final void zzbo() {
        this.zzch();
        Context context = this.getContext();
        if (zzct.zza(context) && zzcu.zze(context)) {
            Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
            intent.setComponent(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsService"));
            context.startService(intent);
            return;
        }
        this.zza((zzca)null);
    }

    public final boolean zzbp() {
        this.zzch();
        Future<Void> future = this.zzbw().zza(new zzap(this));
        try {
            future.get(4L, TimeUnit.SECONDS);
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.zzd("syncDispatchLocalHits interrupted", interruptedException);
            return false;
        }
        catch (ExecutionException executionException) {
            this.zze("syncDispatchLocalHits failed", executionException);
            return false;
        }
        catch (TimeoutException timeoutException) {
            this.zzd("syncDispatchLocalHits timed out", timeoutException);
            return false;
        }
    }

    public final void zzbq() {
        this.zzch();
        zzk.zzab();
        zzbf zzbf2 = this.zzvf;
        zzk.zzab();
        zzbf2.zzch();
        zzbf2.zzp("Service disconnected");
    }

    final void onServiceConnected() {
        zzk.zzab();
        this.zzvf.onServiceConnected();
    }

    final void zzbr() {
        zzk.zzab();
        this.zzvf.zzbr();
    }

    public final void zza(String string, Runnable runnable) {
        Preconditions.checkNotEmpty((String)string, (Object)"campaign param can't be empty");
        this.zzbw().zza(new zzal(this, string, runnable));
    }

    static /* synthetic */ zzbf zza(zzai zzai2) {
        return zzai2.zzvf;
    }
}

