/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbm;
import com.google.android.gms.internal.measurement.zzbn;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzbl
extends zzar {
    private volatile String zzue;
    private Future<String> zzxs;

    protected zzbl(zzat zzat2) {
        super(zzat2);
    }

    @Override
    protected final void zzac() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzdn() {
        this.zzch();
        zzbl zzbl2 = this;
        synchronized (zzbl2) {
            if (this.zzue == null) {
                this.zzxs = this.zzbw().zza(new zzbm(this));
            }
            if (this.zzxs != null) {
                try {
                    this.zzue = this.zzxs.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzue = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzue = "0";
                }
                if (this.zzue == null) {
                    this.zzue = "0";
                }
                this.zza("Loaded clientId", this.zzue);
                this.zzxs = null;
            }
            return this.zzue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzdo() {
        zzbl zzbl2 = this;
        synchronized (zzbl2) {
            this.zzue = null;
            this.zzxs = this.zzbw().zza(new zzbn(this));
        }
        return this.zzdn();
    }

    @VisibleForTesting
    final String zzdp() {
        String string = this.zzd(this.zzbw().getContext());
        if (string == null) {
            string = this.zzdq();
        }
        return string;
    }

    @VisibleForTesting
    private final String zzdq() {
        String string = UUID.randomUUID().toString().toLowerCase(Locale.US);
        try {
            if (!this.zzb(this.zzbw().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzd(Context context) {
        Preconditions.checkNotMainThread((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzs("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzs("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzb(Context context, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotMainThread((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzbl zzbl2) {
        return zzbl2.zzdq();
    }
}

