/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzat;

class zzcn
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzaaw = zzcn.class.getName();
    private final zzat zzvn;
    private boolean zzaax;
    private boolean zzaay;

    zzcn(zzat zzat2) {
        Preconditions.checkNotNull((Object)zzat2);
        this.zzvn = zzat2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzev();
        String string = intent.getAction();
        this.zzvn.zzbu().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzex();
            if (this.zzaay != bl) {
                this.zzaay = bl;
                boolean bl2 = bl;
                zzai zzai2 = this.zzvn.zzby();
                zzai2.zza("Network connectivity status changed", bl2);
                zzai2.zzbw().zza(new zzak(zzai2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzaaw)) {
                zzai zzai3 = this.zzvn.zzby();
                zzai3.zzp("Radio powered up");
                zzai3.zzbo();
            }
            return;
        }
        this.zzvn.zzbu().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzeu() {
        this.zzev();
        if (this.zzaax) {
            return;
        }
        Context context = this.zzvn.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzaay = this.zzex();
        this.zzvn.zzbu().zza("Registering connectivity change receiver. Network connected", this.zzaay);
        this.zzaax = true;
    }

    private final void zzev() {
        this.zzvn.zzbu();
        this.zzvn.zzby();
    }

    public final void unregister() {
        if (!this.zzaax) {
            return;
        }
        this.zzvn.zzbu().zzp("Unregistering connectivity change receiver");
        this.zzaax = false;
        this.zzaay = false;
        Context context = this.zzvn.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzvn.zzbu().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    @VisibleForTesting
    public final void zzew() {
        Context context = this.zzvn.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzaaw, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.zzaax) {
            this.zzvn.zzbu().zzs("Connectivity unknown. Receiver not registered");
        }
        return this.zzaay;
    }

    @VisibleForTesting
    private final boolean zzex() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzvn.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

