/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzct;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcx;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.stats.WakeLock;

public final class zzcu<T extends Context> {
    private final Handler handler;
    private final T zzabm;
    private static Boolean zzabn;

    public zzcu(T t) {
        Preconditions.checkNotNull(t);
        this.zzabm = t;
        this.handler = new Handler();
    }

    public static boolean zze(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzabn != null) {
            return zzabn;
        }
        boolean bl = zzdd.zzc(context, "com.google.android.gms.analytics.AnalyticsService");
        zzabn = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onCreate() {
        zzat.zzc(this.zzabm).zzbu().zzp("Local AnalyticsService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onDestroy() {
        zzat.zzc(this.zzabm).zzbu().zzp("Local AnalyticsService is shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final int onStartCommand(Intent intent, int n, int n2) {
        try {
            Object object = zzct.lock;
            synchronized (object) {
                WakeLock wakeLock = zzct.zzabl;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {}
        zzcm zzcm2 = zzat.zzc(this.zzabm).zzbu();
        if (intent == null) {
            zzcm2.zzs("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcm2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcv(this, n2, zzcm2));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzat.zzc(this.zzabm).zzby().zza(new zzcx(this, runnable));
    }

    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcm zzcm2 = zzat.zzc(this.zzabm).zzbu();
        String string = jobParameters.getExtras().getString("action");
        zzcm2.zza("Local AnalyticsJobService called. action", (Object)string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcw(this, zzcm2, jobParameters));
        }
        return true;
    }

    final /* synthetic */ void zza(zzcm zzcm2, JobParameters jobParameters) {
        zzcm2.zzp("AnalyticsJobService processed last dispatch request");
        ((zzcy)this.zzabm).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzcm zzcm2) {
        if (((zzcy)this.zzabm).callServiceStopSelfResult(n)) {
            zzcm2.zzp("Local AnalyticsService processed last dispatch request");
        }
    }

    static /* synthetic */ Handler zza(zzcu zzcu2) {
        return zzcu2.handler;
    }
}

