/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.zzc;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzbu;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzdd;

@VisibleForTesting
public class CampaignTrackingReceiver
extends BroadcastReceiver {
    private static Boolean zzqt;

    public CampaignTrackingReceiver() {
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzqt != null) {
            return zzqt;
        }
        boolean bl = zzdd.zza(context, "com.google.android.gms.analytics.CampaignTrackingReceiver", true);
        zzqt = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onReceive(Context context, Intent intent) {
        String string;
        zzat zzat2 = zzat.zzc(context);
        zzcm zzcm2 = zzat2.zzbu();
        if (intent == null) {
            zzcm2.zzt("CampaignTrackingReceiver received null intent");
            return;
        }
        String string2 = intent.getStringExtra("referrer");
        String string3 = intent.getAction();
        zzcm2.zza("CampaignTrackingReceiver received", (Object)string3);
        if (!"com.android.vending.INSTALL_REFERRER".equals(string3) || TextUtils.isEmpty((CharSequence)string2)) {
            zzcm2.zzt("CampaignTrackingReceiver received unexpected intent without referrer extra");
            return;
        }
        this.zza(context, string2);
        int n = zzbu.zzdu();
        if (string2.length() <= n) {
            string = string2;
        } else {
            zzcm2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n);
            string = string2.substring(0, n);
        }
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        zzat2.zzby().zza(string, new zzc(this, pendingResult));
    }

    protected void zza(Context context, String string) {
    }
}

