/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdh;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzrl = new ArrayList<Runnable>();
    private boolean zzrm;
    private Set<zza> zzrn = new HashSet<zza>();
    private boolean zzro;
    private boolean zzrp;
    private volatile boolean zzrq;
    private boolean zzrr;

    public final void zzq() {
        GoogleAnalytics googleAnalytics = this;
        zzdh zzdh2 = googleAnalytics.zzl().zzce();
        zzdh2.zzfr();
        if (zzdh2.zzfs()) {
            googleAnalytics.setDryRun(zzdh2.zzft());
        }
        zzdh2.zzfr();
        this.zzrm = true;
    }

    public final boolean isInitialized() {
        return this.zzrm;
    }

    @VisibleForTesting
    public GoogleAnalytics(zzaw zzaw2) {
        super(zzaw2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzaw.zzc(context).zzco();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzr() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzrl != null) {
                Iterator<Runnable> iterator = zzrl.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzrl = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzrp = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzrp;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzro) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzro = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzro) {
            this.zza(activity);
        }
    }

    @VisibleForTesting
    final void zza(Activity activity) {
        Iterator<zza> iterator = this.zzrn.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzc(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzro) {
            this.zzb(activity);
        }
    }

    @VisibleForTesting
    final void zzb(Activity activity) {
        Iterator<zza> iterator = this.zzrn.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzl(), string, null);
            tracker.zzq();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzdf zzdf2;
            Tracker tracker = new Tracker(this.zzl(), null, null);
            if (n > 0 && (zzdf2 = (zzdf)new zzdd(this.zzl()).zzq(n)) != null) {
                tracker.zza(zzdf2);
            }
            tracker.zzq();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzrn.add(zza2);
        Context context = this.zzl().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzrn.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzrq = bl;
        if (this.zzrq) {
            this.zzl().zzcc().zzbr();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzrq;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzco.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzco.setLogger(logger);
        if (!this.zzrr) {
            String string = zzcf.zzyx.get();
            Log.i((String)zzcf.zzyx.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzrr = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzl().zzcc().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzl().zzcc().zzbs();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public final void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zza(activity);
        }

        public final void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzb(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzc(Activity var1);

        public void zzd(Activity var1);
    }
}

