/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbl;
import com.google.android.gms.internal.measurement.zzbm;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcr;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcx;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.internal.measurement.zzy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzbi
extends zzau {
    private boolean started;
    private final zzbf zzxl;
    private final zzcr zzxm;
    private final zzcq zzxn;
    private final zzba zzxo;
    private long zzxp;
    private final zzbz zzxq;
    private final zzbz zzxr;
    private final zzdc zzxs;
    private long zzxt;
    private boolean zzxu;

    protected zzbi(zzaw zzaw2, zzay zzay2) {
        super(zzaw2);
        Preconditions.checkNotNull((Object)zzay2);
        this.zzxp = Long.MIN_VALUE;
        zzaw zzaw3 = zzaw2;
        this.zzxn = new zzcq(zzaw3);
        zzaw3 = zzaw2;
        this.zzxl = new zzbf(zzaw3);
        zzaw3 = zzaw2;
        this.zzxm = new zzcr(zzaw3);
        zzaw3 = zzaw2;
        this.zzxo = new zzba(zzaw3);
        this.zzxs = new zzdc(this.zzbx());
        this.zzxq = new zzbj(this, zzaw2);
        this.zzxr = new zzbk(this, zzaw2);
    }

    @Override
    protected final void zzag() {
        this.zzxl.zzq();
        this.zzxm.zzq();
        this.zzxo.zzq();
    }

    final void start() {
        this.zzcl();
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.started = true;
        this.zzca().zza(new zzbl(this));
    }

    private final boolean zzx(String string) {
        return Wrappers.packageManager((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzdg() {
        this.zzcl();
        zzbi zzbi2 = this;
        zzk.zzaf();
        Context context = zzbi2.zzbw().getContext();
        if (!zzcw.zza(context)) {
            zzbi2.zzt("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzcx.zze(context)) {
            zzbi2.zzu("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zza(context)) {
            zzbi2.zzt("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzcf().zzff();
        if (!this.zzx("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzu("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzdq();
        }
        if (!this.zzx("android.permission.INTERNET")) {
            this.zzu("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzdq();
        }
        if (zzcx.zze(this.getContext())) {
            this.zzq("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzt("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzxu && !this.zzxl.isEmpty()) {
            this.zzdj();
        }
        this.zzdm();
    }

    private final void zzdh() {
        this.zzb(new zzbm(this));
    }

    final void zzbv() {
        zzk.zzaf();
        this.zzxt = this.zzbx().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzk.zzaf();
        zzbi zzbi2 = this;
        zzk.zzaf();
        zzbi2.zzcl();
        if (!zzbx.zzdx()) {
            zzbi2.zzt("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzbi2.zzxo.isConnected()) {
            zzbi2.zzq("Service not connected");
            return;
        }
        if (!zzbi2.zzxl.isEmpty()) {
            zzbi2.zzq("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzck> list;
                try {
                    list = zzbi2.zzxl.zzd(zzbx.zzeb());
                    if (list.isEmpty()) {
                        zzbi2.zzdm();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzbi2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzbi2.zzdo();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzck zzck2 = list.get(0);
                    if (!zzbi2.zzxo.zzb(zzck2)) {
                        zzbi2.zzdm();
                        return;
                    }
                    list.remove(zzck2);
                    try {
                        zzbi2.zzxl.zze(zzck2.zzeq());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzbi2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzbi2.zzdo();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzdi() {
        try {
            this.zzxl.zzdb();
            this.zzdm();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzxr.zzh(86400000L);
    }

    protected final void zzb(zzaz zzaz2) {
        zzk.zzaf();
        this.zzb("Sending first hit to property", zzaz2.zzct());
        if (this.zzcf().zzfg().zzj(zzbx.zzeh())) {
            return;
        }
        String string = this.zzcf().zzfj();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzy zzy2 = zzdg.zza(this.zzby(), string);
        this.zzb("Found relevant installation campaign", zzy2);
        this.zza(zzaz2, zzy2);
    }

    public final void zzg(long l) {
        zzk.zzaf();
        this.zzcl();
        if (l < 0L) {
            l = 0L;
        }
        this.zzxp = l;
        this.zzdm();
    }

    private final void zzdj() {
        if (this.zzxu) {
            return;
        }
        if (!zzbx.zzdx()) {
            return;
        }
        if (this.zzxo.isConnected()) {
            return;
        }
        long l = zzcf.zzaaj.get();
        if (this.zzxs.zzj(l)) {
            this.zzxs.start();
            this.zzq("Connecting to service");
            if (this.zzxo.connect()) {
                this.zzq("Connected to service");
                this.zzxs.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzaz zzaz2, boolean bl) {
        long l;
        Preconditions.checkNotNull((Object)zzaz2);
        this.zzcl();
        zzk.zzaf();
        try {
            this.zzxl.beginTransaction();
            String string = zzaz2.zzbd();
            long l2 = zzaz2.zzcs();
            zzbf zzbf2 = this.zzxl;
            Preconditions.checkNotEmpty((String)string);
            zzbf2.zzcl();
            zzk.zzaf();
            int n = zzbf2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzbf2.zza("Deleted property records", n);
            }
            l = this.zzxl.zza(zzaz2.zzcs(), zzaz2.zzbd(), zzaz2.zzct());
            zzaz2.zzb(l + 1L);
            zzaz zzaz3 = zzaz2;
            zzbf zzbf3 = this.zzxl;
            Preconditions.checkNotNull((Object)zzaz3);
            zzbf3.zzcl();
            zzk.zzaf();
            SQLiteDatabase sQLiteDatabase = zzbf3.getWritableDatabase();
            Map<String, String> map = zzaz3.zzcw();
            Preconditions.checkNotNull(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzaz3.zzcs()));
            contentValues.put("cid", zzaz3.zzbd());
            contentValues.put("tid", zzaz3.zzct());
            contentValues.put("adid", Integer.valueOf(zzaz3.zzcu() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzaz3.zzcv()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzbf3.zzu("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzbf3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzxl.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzxl.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzck zzck2) {
        zzck zzck3;
        Preconditions.checkNotNull((Object)zzck2);
        zzk.zzaf();
        this.zzcl();
        if (this.zzxu) {
            this.zzr("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzck2);
        }
        zzck zzck4 = zzck2;
        zzbi zzbi2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzck4.zzev())) {
            zzck3 = zzck4;
        } else {
            Pair<String, Long> pair = zzbi2.zzcf().zzfk().zzfm();
            if (pair == null) {
                zzck3 = zzck4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzck4.zzcw());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzck zzck5 = zzck4;
                zzbi zzbi3 = zzbi2;
                zzck3 = new zzck(zzbi3, (Map<String, String>)object2, zzck5.zzer(), zzck5.zzet(), zzck5.zzeq(), zzck5.zzep(), zzck5.zzes());
            }
        }
        zzck2 = zzck3;
        this.zzdj();
        if (this.zzxo.zzb(zzck2)) {
            this.zzr("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzxl.zzc(zzck2);
            this.zzdm();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzby().zza(zzck2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzbr() {
        zzk.zzaf();
        this.zzcl();
        this.zzq("Delete all hits from local store");
        try {
            zzbf zzbf2 = this.zzxl;
            zzk.zzaf();
            zzbf2.zzcl();
            zzbf2.getWritableDatabase().delete("hits2", null, null);
            zzbf2 = this.zzxl;
            zzk.zzaf();
            zzbf2.zzcl();
            zzbf2.getWritableDatabase().delete("properties", null, null);
            this.zzdm();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzdj();
        if (this.zzxo.zzcx()) {
            this.zzq("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzdk() {
        boolean bl;
        zzk.zzaf();
        this.zzcl();
        this.zzq("Dispatching a batch of local hits");
        boolean bl2 = !this.zzxo.isConnected();
        boolean bl3 = bl = !this.zzxm.zzfb();
        if (bl2 && bl) {
            this.zzq("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzbx.zzeb(), zzbx.zzec());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzck> list;
                block38: {
                    this.zzxl.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzxl.zzd(l);
                        if (!list.isEmpty()) break block38;
                        this.zzq("Store is empty, nothing to dispatch");
                        this.zzdo();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzdo();
                        try {
                            this.zzxl.setTransactionSuccessful();
                            this.zzxl.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzdo();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzeq() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzdo();
                    return false;
                }
                if (this.zzxo.isConnected()) {
                    this.zzq("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzxo.zzb((zzck)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzck)((Object)list2)).zzeq());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzxl.zze(((zzck)((Object)list2)).zzeq());
                            arrayList.add(((zzck)((Object)list2)).zzeq());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzdo();
                            try {
                                this.zzxl.setTransactionSuccessful();
                                this.zzxl.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzdo();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzxm.zzfb()) {
                    list2 = this.zzxm.zzb(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzxl.zza(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzdo();
                        try {
                            this.zzxl.setTransactionSuccessful();
                            this.zzxl.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzdo();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzxl.setTransactionSuccessful();
                    this.zzxl.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzdo();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzcd zzcd2) {
        long l = this.zzxt;
        zzcd zzcd3 = zzcd2;
        zzbi zzbi2 = this;
        zzk.zzaf();
        zzbi2.zzcl();
        long l2 = -1L;
        long l3 = zzbi2.zzcf().zzfh();
        if (l3 != 0L) {
            l2 = Math.abs(zzbi2.zzbx().currentTimeMillis() - l3);
        }
        zzbi2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzbi2.zzdj();
        try {
            zzbi2.zzdk();
            zzbi2.zzcf().zzfi();
            zzbi2.zzdm();
            if (zzcd3 != null) {
                zzcd3.zza(null);
            }
            if (zzbi2.zzxt != l) {
                zzbi2.zzxn.zzfa();
            }
            return;
        }
        catch (Exception exception) {
            zzbi2.zze("Local dispatch failed", exception);
            zzbi2.zzcf().zzfi();
            zzbi2.zzdm();
            if (zzcd3 != null) {
                zzcd3.zza(exception);
            }
            return;
        }
    }

    public final void zzdl() {
        zzk.zzaf();
        this.zzcl();
        this.zzr("Sync dispatching local hits");
        long l = this.zzxt;
        this.zzdj();
        try {
            this.zzdk();
            this.zzcf().zzfi();
            this.zzdm();
            if (this.zzxt != l) {
                this.zzxn.zzfa();
            }
            return;
        }
        catch (Exception exception) {
            this.zze("Sync local dispatch failed", exception);
            this.zzdm();
            return;
        }
    }

    private final long zzdc() {
        zzk.zzaf();
        this.zzcl();
        try {
            return this.zzxl.zzdc();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzdm() {
        boolean bl;
        zzk.zzaf();
        this.zzcl();
        zzbi zzbi2 = this;
        if (!(!zzbi2.zzxu && zzbi2.zzdp() > 0L)) {
            this.zzxn.unregister();
            this.zzdo();
            return;
        }
        if (this.zzxl.isEmpty()) {
            this.zzxn.unregister();
            this.zzdo();
            return;
        }
        if (!zzcf.zzaae.get().booleanValue()) {
            this.zzxn.zzey();
            bl = this.zzxn.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzbi2 = this;
            zzbi2.zzdn();
            long l3 = zzbi2.zzdp();
            long l4 = zzbi2.zzcf().zzfh();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzbi2.zzbx().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzbx.zzdz(), l3)) : Math.min(zzbx.zzdz(), l3);
            zzbi2.zza("Dispatch scheduled (ms)", l5);
            if (zzbi2.zzxq.zzej()) {
                l = Math.max(1L, l5 + zzbi2.zzxq.zzei());
                zzbi2.zzxq.zzi(l);
                return;
            }
            zzbi2.zzxq.zzh(l5);
            return;
        }
        this.zzdo();
        this.zzdn();
    }

    private final void zzdn() {
        long l;
        zzcc zzcc2 = this.zzcd();
        if (!zzcc2.zzem()) {
            return;
        }
        if (!zzcc2.zzej() && (l = this.zzdc()) != 0L && Math.abs(this.zzbx().currentTimeMillis() - l) <= zzcf.zzzi.get()) {
            long l2 = zzbx.zzea();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzcc2.zzen();
        }
    }

    private final void zzdo() {
        zzbi zzbi2 = this;
        if (zzbi2.zzxq.zzej()) {
            zzbi2.zzq("All hits dispatched or no network/service. Going to power save mode");
        }
        zzbi2.zzxq.cancel();
        zzcc zzcc2 = this.zzcd();
        if (zzcc2.zzej()) {
            zzcc2.cancel();
        }
    }

    private final long zzdp() {
        if (this.zzxp != Long.MIN_VALUE) {
            return this.zzxp;
        }
        long l = zzcf.zzzd.get();
        zzdh zzdh2 = this.zzce();
        zzdh2.zzcl();
        if (zzdh2.zzacr) {
            zzdh2 = this.zzce();
            zzdh2.zzcl();
            l = (long)zzdh2.zzaat * 1000L;
        }
        return l;
    }

    public final void zzy(String string) {
        Preconditions.checkNotEmpty((String)string);
        zzk.zzaf();
        zzy zzy2 = zzdg.zza(this.zzby(), string);
        if (zzy2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzcf().zzfj();
        if (string.equals(string2)) {
            this.zzt("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzcf().zzac(string);
        if (this.zzcf().zzfg().zzj(zzbx.zzeh())) {
            this.zzd("Campaign received too late, ignoring", zzy2);
            return;
        }
        this.zzb("Received installation campaign", zzy2);
        for (zzaz zzaz2 : this.zzxl.zzf(0L)) {
            this.zza(zzaz2, zzy2);
        }
    }

    private final void zza(zzaz zzaz2, zzy zzy2) {
        Preconditions.checkNotNull((Object)zzaz2);
        Preconditions.checkNotNull((Object)zzy2);
        zza zza2 = new zza(this.zzbw());
        zza2.zza(zzaz2.zzct());
        zza2.enableAdvertisingIdCollection(zzaz2.zzcu());
        zzg zzg2 = ((zzj)zza2).zzm();
        zzag zzag2 = zzg2.zzb(zzag.class);
        zzag2.zzl("data");
        zzag2.zzb(true);
        zzg2.zza(zzy2);
        zzab zzab2 = zzg2.zzb(zzab.class);
        zzx zzx2 = zzg2.zzb(zzx.class);
        for (Map.Entry<String, String> entry : zzaz2.zzcw().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzx2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzx2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzx2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzx2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzag2.setUserId(string2);
                continue;
            }
            zzab2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzaz2.zzct(), zzy2);
        zzg2.zza(this.zzcf().zzff());
        zzg2.zzw();
    }

    private final void zzdq() {
        this.zzcl();
        zzk.zzaf();
        this.zzxu = true;
        this.zzxo.disconnect();
        this.zzdm();
    }

    static /* synthetic */ void zza(zzbi zzbi2) {
        zzbi2.zzdh();
    }

    static /* synthetic */ void zzb(zzbi zzbi2) {
        zzbi2.zzdi();
    }
}

