/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcx;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzal
extends zzau {
    private final zzbi zzvq;

    public zzal(zzaw zzaw2, zzay zzay2) {
        super(zzaw2);
        Preconditions.checkNotNull((Object)zzay2);
        zzaw zzaw3 = zzaw2;
        zzay zzay3 = zzay2;
        this.zzvq = new zzbi(zzaw3, zzay3);
    }

    @Override
    protected final void zzag() {
        this.zzvq.zzq();
    }

    public final void start() {
        this.zzvq.start();
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzcl();
        this.zzb("setLocalDispatchPeriod (sec)", n);
        this.zzca().zza(new zzam(this, n));
    }

    public final long zza(zzaz zzaz2) {
        this.zzcl();
        Preconditions.checkNotNull((Object)zzaz2);
        zzk.zzaf();
        long l = this.zzvq.zza(zzaz2, true);
        if (l == 0L) {
            this.zzvq.zzb(zzaz2);
        }
        return l;
    }

    public final void zza(zzck zzck2) {
        Preconditions.checkNotNull((Object)zzck2);
        this.zzcl();
        this.zzb("Hit delivery requested", zzck2);
        this.zzca().zza(new zzap(this, zzck2));
    }

    public final void zzbr() {
        this.zzcl();
        this.zzca().zza(new zzaq(this));
    }

    public final void zza(zzcd zzcd2) {
        this.zzcl();
        this.zzca().zza(new zzar(this, zzcd2));
    }

    public final void zzbs() {
        this.zzcl();
        Context context = this.getContext();
        if (zzcw.zza(context) && zzcx.zze(context)) {
            Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
            intent.setComponent(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsService"));
            context.startService(intent);
            return;
        }
        this.zza((zzcd)null);
    }

    public final boolean zzbt() {
        this.zzcl();
        Future<Void> future = this.zzca().zza(new zzas(this));
        try {
            future.get(4L, TimeUnit.SECONDS);
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.zzd("syncDispatchLocalHits interrupted", interruptedException);
            return false;
        }
        catch (ExecutionException executionException) {
            this.zze("syncDispatchLocalHits failed", executionException);
            return false;
        }
        catch (TimeoutException timeoutException) {
            this.zzd("syncDispatchLocalHits timed out", timeoutException);
            return false;
        }
    }

    public final void zzbu() {
        this.zzcl();
        zzk.zzaf();
        zzbi zzbi2 = this.zzvq;
        zzk.zzaf();
        zzbi2.zzcl();
        zzbi2.zzq("Service disconnected");
    }

    final void onServiceConnected() {
        zzk.zzaf();
        this.zzvq.onServiceConnected();
    }

    final void zzbv() {
        zzk.zzaf();
        this.zzvq.zzbv();
    }

    public final void zza(String string, Runnable runnable) {
        Preconditions.checkNotEmpty((String)string, (Object)"campaign param can't be empty");
        this.zzca().zza(new zzao(this, string, runnable));
    }

    static /* synthetic */ zzbi zza(zzal zzal2) {
        return zzal2.zzvq;
    }
}

